/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import org.jamon.codegen.SequentialIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequentialList<T>
extends AbstractList<T> {
    private final List<? extends T>[] m_lists;
    private final int m_size;

    private SequentialList(List[] p_lists) {
        this.m_lists = p_lists;
        int size = 0;
        for (List list : p_lists) {
            size += list.size();
        }
        this.m_size = size;
    }

    public SequentialList(List<? extends T> p_list1) {
        this(new List[]{p_list1});
    }

    public SequentialList(List<? extends T> p_list1, List<? extends T> p_list2) {
        this(new List[]{p_list1, p_list2});
    }

    public SequentialList(List<? extends T> p_list1, List<? extends T> p_list2, List<? extends T> p_list3) {
        this(new List[]{p_list1, p_list2, p_list3});
    }

    @Override
    public T get(int p_index) {
        if (p_index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int index = p_index;
        for (List<T> list : this.m_lists) {
            if (index >= list.size()) {
                index -= list.size();
                continue;
            }
            return list.get(index);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int size() {
        return this.m_size;
    }

    @Override
    public Iterator<T> iterator() {
        Iterator[] iters = new Iterator[this.m_lists.length];
        for (int i = 0; i < this.m_lists.length; ++i) {
            iters[i] = this.m_lists[i].iterator();
        }
        return new SequentialIterator(iters);
    }
}

