/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jamon.annotations.AnnotationReflector;
import org.jamon.annotations.Argument;
import org.jamon.annotations.Fragment;
import org.jamon.annotations.Method;
import org.jamon.annotations.Template;
import org.jamon.codegen.DeclaredMethodUnit;
import org.jamon.codegen.FragmentArgument;
import org.jamon.codegen.FragmentUnit;
import org.jamon.codegen.GenericParams;
import org.jamon.codegen.MethodUnit;
import org.jamon.codegen.OptionalArgument;
import org.jamon.codegen.RequiredArgument;
import org.jamon.codegen.TemplateUnit;
import org.jamon.codegen.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateDescription {
    private final List<RequiredArgument> m_requiredArgs;
    private final Set<OptionalArgument> m_optionalArgs;
    private final String m_signature;
    private final List<FragmentArgument> m_fragmentInterfaces;
    private final Map<String, MethodUnit> m_methodUnits;
    private final int m_inheritanceDepth;
    private final Collection<String> m_abstractMethodNames;
    private final int m_genericParamsCount;
    private final String m_jamonContextType;
    public static final TemplateDescription EMPTY = new TemplateDescription();

    private TemplateDescription() {
        this.m_requiredArgs = Collections.emptyList();
        this.m_optionalArgs = Collections.emptySet();
        this.m_signature = null;
        this.m_fragmentInterfaces = Collections.emptyList();
        this.m_methodUnits = Collections.emptyMap();
        this.m_inheritanceDepth = -1;
        this.m_abstractMethodNames = Collections.emptyList();
        this.m_genericParamsCount = 0;
        this.m_jamonContextType = null;
    }

    public TemplateDescription(TemplateUnit p_templateUnit) {
        this.m_requiredArgs = new LinkedList<RequiredArgument>();
        this.m_requiredArgs.addAll(p_templateUnit.getSignatureRequiredArgs());
        this.m_optionalArgs = new HashSet<OptionalArgument>();
        this.m_optionalArgs.addAll(p_templateUnit.getSignatureOptionalArgs());
        for (OptionalArgument arg : this.m_optionalArgs) {
            arg.setDefault(null);
        }
        this.m_signature = p_templateUnit.getSignature();
        this.m_fragmentInterfaces = p_templateUnit.getFragmentArgs();
        this.m_methodUnits = new HashMap<String, MethodUnit>();
        for (MethodUnit methodUnit : p_templateUnit.getSignatureMethodUnits()) {
            this.m_methodUnits.put(methodUnit.getName(), methodUnit);
        }
        this.m_inheritanceDepth = p_templateUnit.getInheritanceDepth();
        this.m_abstractMethodNames = p_templateUnit.getAbstractMethodNames();
        this.m_genericParamsCount = p_templateUnit.getGenericParams().getCount();
        this.m_jamonContextType = p_templateUnit.getJamonContextType();
    }

    public TemplateDescription(Class<?> p_proxy) throws NoSuchFieldException {
        Template templateAnnotation = (Template)new AnnotationReflector(p_proxy).getAnnotation(Template.class);
        if (templateAnnotation == null) {
            throw new NoSuchFieldException("class " + p_proxy.getName() + " lacks a template annotation");
        }
        this.m_requiredArgs = TemplateDescription.getRequiredArgs(templateAnnotation.requiredArguments());
        this.m_optionalArgs = TemplateDescription.getOptionalArgs(templateAnnotation.optionalArguments());
        this.m_fragmentInterfaces = TemplateDescription.getFragmentArguments(templateAnnotation.fragmentArguments(), new TemplateUnit(null, null));
        this.m_methodUnits = new HashMap<String, MethodUnit>();
        for (Method methodAnnotation : templateAnnotation.methods()) {
            DeclaredMethodUnit method = new DeclaredMethodUnit(methodAnnotation.name(), null, null, null);
            for (Argument argument : methodAnnotation.requiredArguments()) {
                method.addRequiredArg(TemplateDescription.makeRequiredArg(argument));
            }
            for (Argument argument : methodAnnotation.optionalArguments()) {
                method.addOptionalArg(TemplateDescription.makeOptionalArg(argument));
            }
            for (Argument argument : methodAnnotation.fragmentArguments()) {
                method.addFragmentArg(TemplateDescription.makeFragmentArg(method, (Fragment)argument));
            }
            this.m_methodUnits.put(method.getName(), method);
        }
        this.m_abstractMethodNames = Arrays.asList(templateAnnotation.abstractMethodNames());
        this.m_signature = templateAnnotation.signature();
        this.m_inheritanceDepth = templateAnnotation.inheritanceDepth();
        this.m_genericParamsCount = templateAnnotation.genericsCount();
        this.m_jamonContextType = this.nullToEmptyString(templateAnnotation.jamonContextType());
    }

    private String nullToEmptyString(String jamonContextType) {
        return jamonContextType.equals("") ? null : jamonContextType;
    }

    private static List<RequiredArgument> getRequiredArgs(Argument[] p_arguments) {
        ArrayList<RequiredArgument> args = new ArrayList<RequiredArgument>(p_arguments.length);
        for (Argument argument : p_arguments) {
            args.add(TemplateDescription.makeRequiredArg(argument));
        }
        return args;
    }

    private static Set<OptionalArgument> getOptionalArgs(Argument[] p_arguments) {
        HashSet<OptionalArgument> args = new HashSet<OptionalArgument>();
        for (Argument argument : p_arguments) {
            args.add(TemplateDescription.makeOptionalArg(argument));
        }
        return args;
    }

    private static RequiredArgument makeRequiredArg(Argument argument) {
        return new RequiredArgument(argument.name(), argument.type(), null);
    }

    private static OptionalArgument makeOptionalArg(Argument argument) {
        return new OptionalArgument(argument.name(), argument.type(), null);
    }

    private static List<FragmentArgument> getFragmentArguments(Fragment[] p_fragments, Unit p_parentUnit) {
        ArrayList<FragmentArgument> fragmentArguments = new ArrayList<FragmentArgument>(p_fragments.length);
        for (Fragment fragment : p_fragments) {
            fragmentArguments.add(TemplateDescription.makeFragmentArg(p_parentUnit, fragment));
        }
        return fragmentArguments;
    }

    private static FragmentArgument makeFragmentArg(Unit p_parentUnit, Fragment p_fragment) {
        FragmentUnit fragmentUnit = new FragmentUnit(p_fragment.name(), p_parentUnit, new GenericParams(), null, null);
        for (Argument argument : p_fragment.requiredArguments()) {
            fragmentUnit.addRequiredArg(TemplateDescription.makeRequiredArg(argument));
        }
        FragmentArgument fragmentArgument = new FragmentArgument(fragmentUnit, null);
        return fragmentArgument;
    }

    public List<RequiredArgument> getRequiredArgs() {
        return this.m_requiredArgs;
    }

    public Set<OptionalArgument> getOptionalArgs() {
        return this.m_optionalArgs;
    }

    public String getSignature() {
        return this.m_signature;
    }

    public List<FragmentArgument> getFragmentInterfaces() {
        return this.m_fragmentInterfaces;
    }

    public Map<String, MethodUnit> getMethodUnits() {
        return this.m_methodUnits;
    }

    public Collection<String> getAbstractMethodNames() {
        return this.m_abstractMethodNames;
    }

    public int getInheritanceDepth() {
        return this.m_inheritanceDepth;
    }

    public int getGenericParamsCount() {
        return this.m_genericParamsCount;
    }

    public String getJamonContextType() {
        return this.m_jamonContextType;
    }
}

