/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.compiler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.annotations.Template;
import org.jamon.api.SourceGenerator;
import org.jamon.api.TemplateSource;
import org.jamon.codegen.Analyzer;
import org.jamon.codegen.ImplGenerator;
import org.jamon.codegen.ProxyGenerator;
import org.jamon.codegen.TemplateDescriber;
import org.jamon.codegen.TemplateUnit;
import org.jamon.compiler.FileTemplateSource;
import org.jamon.compiler.TemplateCompilationException;
import org.jamon.util.ExternalJavaCompiler;
import org.jamon.util.InternalJavaCompiler;
import org.jamon.util.JavaCompiler;
import org.jamon.util.StringUtils;
import org.jamon.util.WorkDirClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecompilingTemplateManager
implements TemplateManager {
    private final TemplateSource m_templateSource;
    private final String m_workDir;
    private final ClassLoader m_classLoader;
    private final JavaCompiler m_javaCompiler;
    private final WorkDirClassLoader m_loader;
    private Map<String, DependencyEntry> m_dependencyCache = new HashMap<String, DependencyEntry>();
    private static final boolean TRACE = Boolean.valueOf(System.getProperty(RecompilingTemplateManager.class.getName() + ".trace"));

    public RecompilingTemplateManager() {
        this(new Data());
    }

    private static String getDefaultJavac() {
        String bindir = "Mac OS X".equals(System.getProperty("os.name")) ? "Commands" : "bin";
        return new File(new File(System.getProperty("java.home")).getParent(), bindir) + File.separator + "javac";
    }

    private static JavaCompiler getInternalJavaCompiler(String p_classpath) throws Exception {
        return new InternalJavaCompiler(p_classpath);
    }

    private static JavaCompiler makeCompiler(Data p_data, String p_workDir, ClassLoader p_classLoader) {
        String javac = p_data.javaCompiler;
        if (javac == null) {
            try {
                return RecompilingTemplateManager.getInternalJavaCompiler(RecompilingTemplateManager.getClasspath(p_workDir, p_data.classpath, p_classLoader));
            }
            catch (Exception e) {
                javac = RecompilingTemplateManager.getDefaultJavac();
            }
        }
        return new ExternalJavaCompiler(javac, RecompilingTemplateManager.getClasspath(p_workDir, p_data.classpath, p_classLoader));
    }

    public RecompilingTemplateManager(Data p_data) {
        this.m_classLoader = p_data.classLoader == null ? this.getClass().getClassLoader() : p_data.classLoader;
        this.m_workDir = p_data.workDir == null ? RecompilingTemplateManager.getDefaultWorkDir() : p_data.workDir;
        this.m_javaCompiler = RecompilingTemplateManager.makeCompiler(p_data, this.m_workDir, this.m_classLoader);
        this.m_templateSource = p_data.templateSource != null ? p_data.templateSource : new FileTemplateSource(p_data.sourceDir == null ? System.getProperty("user.dir") : p_data.sourceDir);
        this.m_loader = AccessController.doPrivileged(new PrivilegedAction<WorkDirClassLoader>(){

            @Override
            public WorkDirClassLoader run() {
                return new WorkDirClassLoader(RecompilingTemplateManager.this.m_classLoader, RecompilingTemplateManager.this.m_workDir);
            }
        });
    }

    public AbstractTemplateProxy.Intf constructImpl(AbstractTemplateProxy p_proxy) {
        return p_proxy.constructImpl(this.getImplClass(p_proxy.getClass()));
    }

    public AbstractTemplateProxy constructProxy(String p_path) {
        try {
            return this.getProxyClass(p_path).getConstructor(TemplateManager.class).newInstance(this);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void trace(String p_message) {
        System.err.println(p_message);
    }

    private static String getDefaultWorkDir() {
        File workDir = new File(System.getProperty("java.io.tmpdir"), "jamon" + new Random().nextInt(100000000) + ".tmp");
        if (!workDir.mkdirs()) {
            throw new RuntimeException("Unable to create default work directory " + workDir);
        }
        workDir.deleteOnExit();
        return workDir.toString();
    }

    private static void extractClasspath(ClassLoader p_classLoader, StringBuilder p_classpath) {
        if (p_classLoader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)p_classLoader).getURLs();
            for (int i = 0; i < urls.length; ++i) {
                String url = urls[i].toExternalForm();
                if (!url.startsWith("file:")) continue;
                p_classpath.append(File.pathSeparator);
                p_classpath.append(url.substring(5));
            }
        }
        if (p_classLoader.getParent() != null) {
            RecompilingTemplateManager.extractClasspath(p_classLoader.getParent(), p_classpath);
        }
    }

    private static String getClasspath(String p_start, String p_classpath, ClassLoader p_classLoader) {
        StringBuilder cp = new StringBuilder(p_start);
        if (p_classpath != null) {
            cp.append(File.pathSeparator);
            cp.append(p_classpath);
        }
        RecompilingTemplateManager.extractClasspath(p_classLoader, cp);
        cp.append(File.pathSeparator);
        cp.append(System.getProperty("sun.boot.class.path"));
        cp.append(File.pathSeparator);
        cp.append(System.getProperty("java.class.path"));
        RecompilingTemplateManager.pruneJniLibs(cp);
        if (TRACE) {
            RecompilingTemplateManager.trace("Jamon compilation CLASSPATH is " + cp);
        }
        return cp.toString();
    }

    private static void pruneJniLibs(StringBuilder cp) {
        String[] components = cp.toString().split(File.pathSeparator);
        cp.delete(0, cp.length());
        boolean first = true;
        for (String c : components) {
            if (c.endsWith(".jnilib") || c.endsWith(".dylib")) continue;
            if (!first) {
                cp.append(File.pathSeparator);
            }
            first = false;
            cp.append(c);
        }
    }

    private Class<? extends AbstractTemplateImpl> getImplClass(Class<? extends AbstractTemplateProxy> p_proxyClass) {
        return this.getTemplateClass(StringUtils.classToTemplatePath(p_proxyClass), p_proxyClass.getName() + "Impl").asSubclass(AbstractTemplateImpl.class);
    }

    private Class<? extends AbstractTemplateProxy> getProxyClass(String p_path) {
        return this.getTemplateClass(p_path, StringUtils.templatePathToClassName(p_path)).asSubclass(AbstractTemplateProxy.class);
    }

    private Class<?> getTemplateClass(String p_path, String p_className) {
        try {
            try {
                this.ensureUpToDate(p_path, new TemplateDescriber(this.m_templateSource, this.m_loader));
                return this.m_loader.loadClass(p_className);
            }
            catch (ClassNotFoundException e) {
                if (!this.m_templateSource.available(p_path)) {
                    throw new RuntimeException("The template at path " + p_path + " could not be found");
                }
                throw new RuntimeException(e);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String prefix() {
        return this.m_workDir;
    }

    private String javaImpl(String p_path) {
        return this.prefix() + p_path + "Impl.java";
    }

    private String classImpl(String p_path) {
        return this.prefix() + p_path + "Impl.class";
    }

    private String javaIntf(String p_path) {
        return this.prefix() + p_path + ".java";
    }

    private synchronized void ensureUpToDate(String p_path, TemplateDescriber p_describer) throws IOException {
        HashSet<String> seen = new HashSet<String>();
        HashSet<String> outOfDateJavaFiles = new HashSet<String>();
        LinkedList<String> workQueue = new LinkedList<String>();
        workQueue.add(p_path);
        while (!workQueue.isEmpty()) {
            DependencyEntry d;
            String path = (String)workQueue.remove(0);
            if (TRACE) {
                RecompilingTemplateManager.trace("processing " + path);
            }
            seen.add(path);
            if (!this.m_templateSource.available(path)) {
                if (!TRACE) continue;
                RecompilingTemplateManager.trace(path + " source not found; assume class exists");
                continue;
            }
            boolean intfGenerated = false;
            long modTime = this.m_templateSource.lastModified(path);
            String intfFileName = this.javaIntf(path);
            File intfFile = new File(intfFileName);
            if (intfFile.lastModified() < modTime) {
                TemplateUnit templateUnit = new Analyzer(path, p_describer).analyze();
                String signature = templateUnit.getSignature();
                if (this.isIntfChanged(path, signature, this.m_classLoader)) {
                    if (this.isIntfChanged(path, signature, this.m_loader)) {
                        this.generateIntf(path, p_describer, templateUnit);
                        outOfDateJavaFiles.add(intfFileName);
                        intfGenerated = true;
                    }
                } else {
                    intfFile.delete();
                    this.deleteClassFilesFor(path);
                }
            }
            File jm = new File(this.javaImpl(path));
            long ts = jm.lastModified();
            if (jm.lastModified() < modTime) {
                this.m_dependencyCache.put(path, new DependencyEntry(this.generateImpl(path, p_describer)));
                ts = System.currentTimeMillis();
            }
            if (new File(this.classImpl(path)).lastModified() < ts || intfGenerated) {
                outOfDateJavaFiles.add(this.javaImpl(path));
            }
            if ((d = this.m_dependencyCache.get(path)) == null || d.lastUpdated() < modTime) {
                d = new DependencyEntry(this.computeDependencies(path, p_describer));
                this.m_dependencyCache.put(path, d);
            }
            for (String dp : d.getDependencies()) {
                if (seen.contains(dp)) continue;
                workQueue.add(dp);
            }
        }
        if (!outOfDateJavaFiles.isEmpty()) {
            String errors = this.compile(outOfDateJavaFiles);
            this.m_loader.invalidate();
            if (errors != null) {
                throw new TemplateCompilationException(errors);
            }
        }
    }

    private void deleteClassFilesFor(String p_path) {
        int i = p_path.lastIndexOf(47);
        String templateName = i < 0 ? p_path : p_path.substring(i + 1);
        File dir = new File(new File(this.m_workDir), StringUtils.templatePathToFileDir(p_path));
        String[] files = dir.list();
        if (files != null) {
            for (int j = 0; j < files.length; ++j) {
                if (!StringUtils.isGeneratedClassFilename(templateName, files[j])) continue;
                new File(dir, files[j]).delete();
            }
        }
    }

    private File getWriteableFile(String p_filename) {
        File file = new File(p_filename);
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        return file;
    }

    private void generateSource(String p_filename, SourceGenerator p_sourceGenerator) throws IOException {
        File javaFile = this.getWriteableFile(p_filename);
        FileOutputStream out = new FileOutputStream(javaFile);
        try {
            p_sourceGenerator.generateSource((OutputStream)out);
            out.close();
        }
        catch (IOException e) {
            out.close();
            javaFile.delete();
            throw e;
        }
    }

    private Collection<String> generateImpl(String p_path, TemplateDescriber p_describer) throws IOException {
        if (TRACE) {
            RecompilingTemplateManager.trace("generating impl for " + p_path);
        }
        TemplateUnit templateUnit = new Analyzer(p_path, p_describer).analyze();
        this.generateSource(this.javaImpl(p_path), new ImplGenerator(p_describer, templateUnit));
        return templateUnit.getTemplateDependencies();
    }

    private void generateIntf(String p_path, TemplateDescriber p_describer, TemplateUnit p_templateUnit) throws IOException {
        if (TRACE) {
            RecompilingTemplateManager.trace("generating intf for " + p_path);
        }
        this.generateSource(this.javaIntf(p_path), new ProxyGenerator(p_describer, p_templateUnit));
    }

    private String getIntfSignatureFromClass(String p_path, ClassLoader p_loader) {
        if (TRACE) {
            RecompilingTemplateManager.trace("Looking for signature of " + StringUtils.templatePathToClassName(p_path));
        }
        try {
            return p_loader.loadClass(StringUtils.templatePathToClassName(p_path)).getAnnotation(Template.class).signature();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private boolean isIntfChanged(String p_path, String p_signature, ClassLoader p_loader) {
        return !p_signature.equals(this.getIntfSignatureFromClass(p_path, p_loader));
    }

    private String compile(Collection<String> p_sourceFiles) {
        if (p_sourceFiles.isEmpty()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("compiling: ");
        StringUtils.commaJoin(buf, p_sourceFiles);
        if (TRACE) {
            RecompilingTemplateManager.trace(buf.toString());
        }
        return this.m_javaCompiler.compile(p_sourceFiles.toArray(new String[p_sourceFiles.size()]));
    }

    private Collection<String> computeDependencies(String p_path, TemplateDescriber p_describer) throws IOException {
        if (TRACE) {
            RecompilingTemplateManager.trace("computing dependencies for " + p_path);
        }
        return new Analyzer(p_path, p_describer).analyze().getTemplateDependencies();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DependencyEntry {
        Collection<String> m_dependencies;
        long m_lastUpdated;

        DependencyEntry(Collection<String> p_dependencies) {
            this.m_dependencies = p_dependencies;
            this.m_lastUpdated = System.currentTimeMillis();
        }

        Collection<String> getDependencies() {
            return this.m_dependencies;
        }

        long lastUpdated() {
            return this.m_lastUpdated;
        }
    }

    public static class Data {
        private String sourceDir;
        private TemplateSource templateSource;
        private String workDir;
        private String javaCompiler;
        private String classpath;
        private ClassLoader classLoader = this.getClass().getClassLoader();

        public Data setSourceDir(String p_sourceDir) {
            this.sourceDir = p_sourceDir;
            return this;
        }

        public Data setTemplateSource(TemplateSource p_templateSource) {
            this.templateSource = p_templateSource;
            return this;
        }

        public Data setWorkDir(String p_workDir) {
            this.workDir = p_workDir;
            return this;
        }

        public Data setJavaCompiler(String p_javaCompiler) {
            this.javaCompiler = p_javaCompiler;
            return this;
        }

        public Data setClasspath(String p_classpath) {
            this.classpath = p_classpath;
            return this;
        }

        public Data setClassLoader(ClassLoader p_classLoader) {
            this.classLoader = p_classLoader;
            return this;
        }
    }
}

