/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import java.io.IOException;
import java.io.Reader;
import org.jamon.api.Location;
import org.jamon.api.TemplateLocation;
import org.jamon.node.LocationImpl;

public class PositionalPushbackReader {
    private final Reader m_reader;
    private final TemplateLocation m_templateLocation;
    int m_pushedbackCharsPending = 0;
    final int[] m_pushedbackChars;
    private final Position[] m_positions;
    private Position m_currentNodePosition = new Position();

    public PositionalPushbackReader(TemplateLocation p_templateLocation, Reader p_reader) {
        this(p_templateLocation, p_reader, 1);
    }

    public PositionalPushbackReader(TemplateLocation p_templateLocation, Reader p_reader, int p_pushbackBufferSize) {
        this.m_reader = p_reader;
        this.m_templateLocation = p_templateLocation;
        this.m_positions = new Position[p_pushbackBufferSize + 2];
        for (int i = 0; i < this.m_positions.length; ++i) {
            this.m_positions[i] = new Position();
        }
        this.m_pushedbackChars = new int[p_pushbackBufferSize];
    }

    public int read() throws IOException {
        int c = this.m_pushedbackCharsPending > 0 ? this.m_pushedbackChars[--this.m_pushedbackCharsPending] : this.m_reader.read();
        for (int i = this.m_positions.length - 1; i > 0; --i) {
            this.m_positions[i].assign(this.m_positions[i - 1]);
        }
        if (c == 10) {
            this.m_positions[0].nextRow();
        } else {
            this.m_positions[0].nextColumn();
        }
        return c;
    }

    public void unread(int c) throws IOException {
        if (this.m_pushedbackCharsPending >= this.m_pushedbackChars.length) {
            throw new IOException("Trying to push back characters than allowed");
        }
        this.m_pushedbackChars[this.m_pushedbackCharsPending++] = c;
        for (int i = 0; i < this.m_positions.length - 1; ++i) {
            this.m_positions[i].assign(this.m_positions[i + 1]);
        }
    }

    public Location getLocation() {
        return this.m_positions[1].location(this.m_templateLocation);
    }

    public Location getNextLocation() {
        return this.m_positions[0].location(this.m_templateLocation);
    }

    public boolean isLineStart() {
        return this.m_positions[1].isLineStart();
    }

    public void markNodeBeginning() {
        this.m_currentNodePosition.assign(this.m_positions[1]);
    }

    public void markNodeEnd() {
        this.m_currentNodePosition.assign(this.m_positions[0]);
    }

    public Location getCurrentNodeLocation() {
        return this.m_currentNodePosition.location(this.m_templateLocation);
    }

    private static class Position {
        private int m_row = 1;
        private int m_column = 1;

        private Position() {
        }

        void assign(Position p_position) {
            this.m_row = p_position.m_row;
            this.m_column = p_position.m_column;
        }

        public void nextColumn() {
            ++this.m_column;
        }

        public void nextRow() {
            ++this.m_row;
            this.m_column = 1;
        }

        public Location location(TemplateLocation p_templateLocation) {
            return new LocationImpl(p_templateLocation, this.m_row, this.m_column);
        }

        public boolean isLineStart() {
            return this.m_column == 1;
        }
    }
}

