/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.parser;

import java.io.IOException;
import java.io.Reader;
import org.jamon.api.Location;
import org.jamon.api.TemplateLocation;
import org.jamon.codegen.AnnotationType;
import org.jamon.compiler.ParserErrorImpl;
import org.jamon.compiler.ParserErrorsImpl;
import org.jamon.node.AbsMethodNode;
import org.jamon.node.AbstractNode;
import org.jamon.node.AbstractPathNode;
import org.jamon.node.AliasDefNode;
import org.jamon.node.AliasesNode;
import org.jamon.node.AnnotationNode;
import org.jamon.node.ClassNode;
import org.jamon.node.EscapeDirectiveNode;
import org.jamon.node.ExtendsNode;
import org.jamon.node.ImplementNode;
import org.jamon.node.ImplementsNode;
import org.jamon.node.ImportsNode;
import org.jamon.node.LocationImpl;
import org.jamon.node.ParentMarkerNode;
import org.jamon.node.TopNode;
import org.jamon.parser.AbstractBodyParser;
import org.jamon.parser.ArgsParser;
import org.jamon.parser.DefParser;
import org.jamon.parser.FragmentArgsParser;
import org.jamon.parser.GenericsParser;
import org.jamon.parser.HashEndDetector;
import org.jamon.parser.ImportParser;
import org.jamon.parser.MethodParser;
import org.jamon.parser.OverrideParser;
import org.jamon.parser.ParentArgsParser;
import org.jamon.parser.PositionalPushbackReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopLevelParser
extends AbstractBodyParser<TopNode> {
    public static final String BAD_ABSMETH_CONTENT = "<%absmeth> sections can only contain <%args> and <%frag> blocks";
    public static final String EXPECTING_SEMI = "Expecting ';'";
    public static final String EXPECTING_ARROW = "Expecting '=' or '=>'";
    public static final String MALFORMED_EXTENDS_TAG_ERROR = "Malformed <%extends ...> tag";
    public static final String MALFORMED_ANNOTATE_TAG_ERROR = "Malformed <%annotate...> tag";
    public static final String UNRECOGNIZED_ANNOTATION_TYPE_ERROR = "Unrecognized annotation type";
    private static final String BAD_ALIASES_CLOSE_TAG = "Malformed </%alias> tag";
    private static final String BAD_ABS_METHOD_CLOSE_TAG = "Malformed </%absmeth> tag";
    public static final String EXPECTING_IMPLEMENTS_CLOSE = "Expecting class name or </%implements>";
    public static final String EXPECTING_IMPORTS_CLOSE = "Expecting import or </%import>";

    public TopLevelParser(TemplateLocation p_location, Reader p_reader) {
        super(new TopNode(new LocationImpl(p_location, 1, 1)), new PositionalPushbackReader(p_location, p_reader, 2), new ParserErrorsImpl());
    }

    @Override
    public AbstractBodyParser<TopNode> parse() throws IOException {
        super.parse();
        if (this.m_errors.hasErrors()) {
            throw this.m_errors;
        }
        return this;
    }

    @Override
    protected void handleMethodTag(Location p_tagLocation) throws IOException {
        if (this.soakWhitespace()) {
            String name = this.readIdentifier(true);
            if (this.checkForTagClosure(p_tagLocation)) {
                ((TopNode)this.m_root).addSubNode((AbstractNode)new MethodParser(name, p_tagLocation, this.m_reader, this.m_errors).parse().getRootNode());
            }
        } else {
            this.addError(p_tagLocation, "malformed <%method methodName> tag");
        }
    }

    @Override
    protected void handleOverrideTag(Location p_tagLocation) throws IOException {
        if (this.soakWhitespace()) {
            String name = this.readIdentifier(true);
            if (this.checkForTagClosure(p_tagLocation)) {
                ((TopNode)this.m_root).addSubNode((AbstractNode)new OverrideParser(name, p_tagLocation, this.m_reader, this.m_errors).parse().getRootNode());
            }
        } else {
            this.addError(p_tagLocation, "malformed <%override methodName> tag");
        }
    }

    @Override
    protected void handleDefTag(Location p_tagLocation) throws IOException {
        if (this.soakWhitespace()) {
            String name = this.readIdentifier(true);
            if (this.checkForTagClosure(p_tagLocation)) {
                ((TopNode)this.m_root).addSubNode((AbstractNode)new DefParser(name, p_tagLocation, this.m_reader, this.m_errors).parse().getRootNode());
            }
        } else {
            this.addError(p_tagLocation, "malformed <%def defName> tag");
        }
    }

    @Override
    protected void handleClassTag(Location p_tagLocation) throws IOException {
        if (this.checkForTagClosure(p_tagLocation)) {
            ((TopNode)this.m_root).addSubNode(new ClassNode(p_tagLocation, this.readUntil("</%class>", p_tagLocation)));
            this.soakWhitespace();
        }
    }

    @Override
    protected void handleExtendsTag(Location p_tagLocation) throws IOException {
        if (this.soakWhitespace()) {
            ((TopNode)this.m_root).addSubNode(new ExtendsNode(p_tagLocation, this.parsePath()));
            this.soakWhitespace();
            this.checkForTagClosure(this.m_reader.getLocation());
            this.soakWhitespace();
        } else {
            this.addError(p_tagLocation, MALFORMED_EXTENDS_TAG_ERROR);
        }
    }

    @Override
    protected void handleImplementsTag(Location p_tagLocation) throws IOException {
        if (this.checkForTagClosure(p_tagLocation)) {
            ImplementsNode implementsNode = new ImplementsNode(p_tagLocation);
            ((TopNode)this.m_root).addSubNode(implementsNode);
            while (true) {
                this.soakWhitespace();
                Location location = this.m_reader.getNextLocation();
                if (this.readChar('<')) {
                    if (!this.checkToken("/%implements>")) {
                        this.addError(location, EXPECTING_IMPLEMENTS_CLOSE);
                    }
                    this.soakWhitespace();
                    return;
                }
                String className = this.readClassName(this.m_reader.getCurrentNodeLocation());
                if (className.length() == 0) {
                    this.addError(location, EXPECTING_IMPLEMENTS_CLOSE);
                    return;
                }
                if (!this.readChar(';')) {
                    this.addError(this.m_reader.getNextLocation(), EXPECTING_SEMI);
                }
                implementsNode.addImplement(new ImplementNode(location, className));
            }
        }
    }

    @Override
    protected void handleImportTag(Location p_tagLocation) throws IOException {
        if (this.checkForTagClosure(p_tagLocation)) {
            ImportsNode importsNode = new ImportsNode(p_tagLocation);
            ((TopNode)this.m_root).addSubNode(importsNode);
            while (true) {
                this.soakWhitespace();
                Location location = this.m_reader.getNextLocation();
                if (this.readChar('<')) {
                    if (!this.checkToken("/%import>")) {
                        this.addError(location, EXPECTING_IMPORTS_CLOSE);
                    }
                    this.soakWhitespace();
                    return;
                }
                try {
                    importsNode.addImport(new ImportParser(this.m_reader, this.m_errors).parse().getNode());
                }
                catch (ParserErrorImpl e) {
                    this.addError(e);
                    this.addError(this.m_reader.getLocation(), EXPECTING_IMPORTS_CLOSE);
                    return;
                }
                this.soakWhitespace();
                if (this.readChar(';')) continue;
                this.addError(this.m_reader.getNextLocation(), EXPECTING_SEMI);
            }
        }
    }

    @Override
    protected void handleAliasesTag(Location p_tagLocation) throws IOException {
        this.checkForTagClosure(p_tagLocation);
        AliasesNode aliases = new AliasesNode(p_tagLocation);
        ((TopNode)this.m_root).addSubNode(aliases);
        while (true) {
            String name;
            this.soakWhitespace();
            this.m_reader.markNodeEnd();
            if (this.readChar('<')) {
                if (!this.checkToken("/%alias>")) {
                    this.addError(this.m_reader.getLocation(), BAD_ALIASES_CLOSE_TAG);
                }
                this.soakWhitespace();
                return;
            }
            String string = name = this.readChar('/') ? "/" : this.readIdentifier(false);
            if (name.length() == 0) {
                this.addError(this.m_reader.getCurrentNodeLocation(), "Alias name expected");
                return;
            }
            this.soakWhitespace();
            if (this.readChar('=')) {
                this.readChar('>');
                this.soakWhitespace();
                AbstractPathNode path = this.parsePath();
                if (path.getPathElements().isEmpty()) {
                    return;
                }
                aliases.addAlias(new AliasDefNode(this.m_reader.getCurrentNodeLocation(), name, path));
                if (this.readChar(';')) continue;
                this.addError(this.m_reader.getLocation(), EXPECTING_SEMI);
                continue;
            }
            this.addError(this.m_reader.getLocation(), EXPECTING_ARROW);
        }
    }

    @Override
    protected void handleAbsMethodTag(Location p_tagLocation) throws IOException {
        if (this.soakWhitespace()) {
            block8: {
                block9: {
                    String name = this.readIdentifier(true);
                    this.checkForTagClosure(p_tagLocation);
                    AbsMethodNode absMethodNode = new AbsMethodNode(p_tagLocation, name);
                    ((TopNode)this.m_root).addSubNode(absMethodNode);
                    while (true) {
                        this.soakWhitespace();
                        this.m_reader.markNodeEnd();
                        if (!this.readChar('<')) break block8;
                        if (!this.readChar('%')) break block9;
                        String tagName = this.readTagName();
                        if ("args".equals(tagName)) {
                            try {
                                absMethodNode.addArgsBlock(new ArgsParser(this.m_reader, this.m_errors, this.m_reader.getCurrentNodeLocation()).getArgsNode());
                            }
                            catch (ParserErrorImpl e) {
                                this.addError(e);
                            }
                            continue;
                        }
                        if (!"frag".equals(tagName)) break;
                        try {
                            absMethodNode.addArgsBlock(new FragmentArgsParser(this.m_reader, this.m_errors, this.m_reader.getCurrentNodeLocation()).getFragmentArgsNode());
                        }
                        catch (ParserErrorImpl e) {
                            this.addError(e);
                        }
                    }
                    this.addError(this.m_reader.getLocation(), BAD_ABSMETH_CONTENT);
                    return;
                }
                if (!this.checkToken("/%absmeth>")) {
                    this.addError(this.m_reader.getLocation(), BAD_ABS_METHOD_CLOSE_TAG);
                }
                this.soakWhitespace();
                return;
            }
            this.addError(this.m_reader.getLocation(), BAD_ABSMETH_CONTENT);
            return;
        }
        this.addError(this.m_reader.getLocation(), "malformed <%absmeth methodName> tag");
    }

    @Override
    protected void handleParentArgsNode(Location p_tagLocation) throws IOException {
        ((TopNode)this.m_root).addSubNode(new ParentArgsParser(this.m_reader, this.m_errors, p_tagLocation).getParentArgsNode());
    }

    @Override
    protected void handleParentMarkerTag(Location p_tagLocation) throws IOException {
        if (this.checkForTagClosure(p_tagLocation)) {
            ((TopNode)this.m_root).addSubNode(new ParentMarkerNode(p_tagLocation));
            this.soakWhitespace();
        }
    }

    @Override
    protected void handleEof() {
    }

    @Override
    protected void handleEscapeTag(Location p_tagLocation) throws IOException {
        this.soakWhitespace();
        if (!this.readChar('#')) {
            this.addError(this.m_reader.getNextLocation(), "Expecting '#'");
        } else {
            this.soakWhitespace();
            int c = this.m_reader.read();
            if (Character.isLetter((char)c)) {
                ((TopNode)this.m_root).addSubNode(new EscapeDirectiveNode(p_tagLocation, new String(new char[]{(char)c})));
            } else {
                this.addError(this.m_reader.getLocation(), "Expecting a letter");
            }
            this.soakWhitespace();
            this.checkForTagClosure(p_tagLocation);
        }
        this.soakWhitespace();
    }

    @Override
    protected void handleGenericTag(Location p_tagLocation) throws IOException {
        ((TopNode)this.m_root).addSubNode(new GenericsParser(this.m_reader, this.m_errors, p_tagLocation).getGenericsNode());
    }

    @Override
    protected void handleAnnotationTag(Location p_tagLocation) throws IOException {
        if (this.soakWhitespace()) {
            try {
                AnnotationType annotationType;
                HashEndDetector detector = new HashEndDetector();
                String annotations = this.readJava(p_tagLocation, detector);
                if (detector.endedWithHash()) {
                    annotationType = this.readAnnotationType();
                    this.soakWhitespace();
                    if (!this.readChar('%') || !this.readChar('>')) {
                        throw new ParserErrorImpl(p_tagLocation, MALFORMED_ANNOTATE_TAG_ERROR);
                    }
                } else {
                    annotationType = AnnotationType.BOTH;
                }
                ((TopNode)this.m_root).addSubNode(new AnnotationNode(p_tagLocation, annotations, annotationType));
            }
            catch (ParserErrorImpl e) {
                this.addError(e);
            }
            this.soakWhitespace();
        } else {
            this.addError(p_tagLocation, MALFORMED_ANNOTATE_TAG_ERROR);
        }
    }

    private AnnotationType readAnnotationType() throws IOException, ParserErrorImpl {
        Location location = this.m_reader.getLocation();
        if (this.readChar('p')) {
            if (this.checkToken("roxy")) {
                return AnnotationType.PROXY;
            }
        } else if (this.readChar('i') && this.checkToken("mpl")) {
            return AnnotationType.IMPL;
        }
        throw new ParserErrorImpl(location, UNRECOGNIZED_ANNOTATION_TYPE_ERROR);
    }

    @Override
    protected boolean isTopLevel() {
        return true;
    }
}

