/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.util;

import java.io.IOException;
import java.io.InputStream;
import org.jamon.util.JavaCompiler;

public class ExternalJavaCompiler
implements JavaCompiler {
    private final String m_javac;
    private final String m_classPath;

    public ExternalJavaCompiler(String p_javac, String p_classPath) {
        this.m_javac = p_javac;
        this.m_classPath = p_classPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String compile(String[] p_javaFiles) {
        Process p;
        String[] cmdline = new String[p_javaFiles.length + 3];
        System.arraycopy(p_javaFiles, 0, cmdline, 3, p_javaFiles.length);
        cmdline[0] = this.m_javac;
        cmdline[1] = "-classpath";
        cmdline[2] = this.m_classPath;
        try {
            p = Runtime.getRuntime().exec(cmdline);
        }
        catch (IOException e) {
            return e.getMessage();
        }
        StreamConsumer stderr = new StreamConsumer(p.getErrorStream());
        try {
            Thread errThread = new Thread(stderr);
            errThread.start();
            int code = -1;
            try {
                code = p.waitFor();
            }
            catch (InterruptedException e) {
                errThread.interrupt();
            }
            try {
                errThread.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            String string = code == 0 ? null : stderr.getContents();
            return string;
        }
        finally {
            try {
                stderr.close();
            }
            catch (IOException e) {
                return e.getMessage();
            }
        }
    }

    private static class StreamConsumer
    implements Runnable {
        private final InputStream m_stream;
        private final StringBuilder m_buffer = new StringBuilder();

        StreamConsumer(InputStream p_stream) {
            this.m_stream = p_stream;
        }

        private void close() throws IOException {
            this.m_stream.close();
        }

        synchronized String getContents() {
            return this.m_buffer.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte[] buf = new byte[1024];
            boolean eof = false;
            while (!eof) {
                try {
                    int read = this.m_stream.read(buf);
                    if (read == -1) {
                        eof = true;
                        continue;
                    }
                    if (read == 0) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            eof = true;
                        }
                        continue;
                    }
                    StringBuilder stringBuilder = this.m_buffer;
                    synchronized (stringBuilder) {
                        this.m_buffer.append(new String(buf, 0, read));
                    }
                }
                catch (IOException e) {
                    eof = true;
                }
            }
        }
    }
}

