/*
 * Decompiled with CFR 0.152.
 */
package org.jamon.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jamon.util.JavaCompiler;

public class InternalJavaCompiler
implements JavaCompiler {
    private final String m_classPath;
    private final Method m_compile;
    private final Class<? extends Object> m_compilerClass;
    private Object m_compiler;

    public InternalJavaCompiler(String p_classPath) throws Exception {
        this.m_classPath = p_classPath;
        this.m_compilerClass = Class.forName("com.sun.tools.javac.Main");
        this.m_compiler = this.m_compilerClass.newInstance();
        this.m_compile = this.m_compilerClass.getMethod("compile", new String[0].getClass());
        this.m_compile.invoke(this.m_compiler, new Object[0]);
    }

    public String compile(String[] p_javaFiles) {
        String[] cmdline = new String[p_javaFiles.length + 2];
        System.arraycopy(p_javaFiles, 0, cmdline, 2, p_javaFiles.length);
        cmdline[0] = "-classpath";
        cmdline[1] = this.m_classPath;
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        PrintStream pErr = new PrintStream(err);
        PrintStream oldErr = System.err;
        try {
            if (this.m_compiler == null) {
                this.m_compiler = this.m_compilerClass.newInstance();
            }
            System.setErr(new PrintStream(err));
            int code = (Integer)this.m_compile.invoke(this.m_compiler, new Object[]{cmdline});
            pErr.close();
            String string = code == 0 ? null : new String(err.toByteArray());
            return string;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            this.m_compiler = null;
            throw new RuntimeException(e.getTargetException());
        }
        finally {
            System.setErr(oldErr);
        }
    }
}

