/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.utils;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import org.jarbframework.utils.Classes;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class ClassScanner {
    public static Set<Class<?>> getAllOfType(String basePackage, Class<?> targetType) {
        return ClassScanner.getAll(basePackage, (TypeFilter)new AssignableTypeFilter(targetType));
    }

    public static Set<Class<?>> getAllWithAnnotation(String basePackage, Class<? extends Annotation> annotationClass) {
        return ClassScanner.getAll(basePackage, (TypeFilter)new AnnotationTypeFilter(annotationClass));
    }

    private static Set<Class<?>> getAll(String basePackage, TypeFilter filter) {
        ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
        componentProvider.addIncludeFilter(filter);
        Set beanDefinitions = componentProvider.findCandidateComponents(basePackage);
        HashSet beanClasses = new HashSet(beanDefinitions.size());
        for (BeanDefinition beanDefinition : beanDefinitions) {
            Class beanClass = Classes.forName(beanDefinition.getBeanClassName());
            beanClasses.add(beanClass);
        }
        return beanClasses;
    }
}

