/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.utils.bean;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.jarbframework.utils.Asserts;
import org.jarbframework.utils.bean.BeanProperties;
import org.jarbframework.utils.bean.PropertyReference;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class AnnotationScanner {
    private final boolean includeGetter;

    public AnnotationScanner(boolean includeGetter) {
        this.includeGetter = includeGetter;
    }

    public static AnnotationScanner field() {
        return new AnnotationScanner(false);
    }

    public static AnnotationScanner fieldOrGetter() {
        return new AnnotationScanner(true);
    }

    public <T extends Annotation> T findAnnotation(Class<?> beanClass, Class<T> annotationType) {
        return (T)AnnotationUtils.findAnnotation(beanClass, annotationType);
    }

    public boolean hasAnnotation(Class<?> beanClass, Class<? extends Annotation> annotationType) {
        return this.findAnnotation(beanClass, annotationType) != null;
    }

    public <T extends Annotation> T findAnnotation(PropertyReference propertyReference, Class<T> annotationType) {
        Collection<T> annotations = this.getAnnotations(propertyReference, annotationType);
        if (annotations.isEmpty()) {
            return null;
        }
        Asserts.state(annotations.size() == 1, "Found more than one matching annotation.");
        return (T)((Annotation)annotations.iterator().next());
    }

    public <T extends Annotation> Collection<T> getAnnotations(PropertyReference propertyReference, Class<T> annotationType) {
        T getterAnnotation;
        propertyReference = BeanProperties.getFinalProperty(propertyReference);
        ArrayList<T> annotations = new ArrayList<T>();
        T fieldAnnotation = this.getFieldAnnotation(propertyReference, annotationType);
        if (fieldAnnotation != null) {
            annotations.add(fieldAnnotation);
        }
        if ((getterAnnotation = this.getGetterAnnotation(propertyReference, annotationType)) != null) {
            annotations.add(getterAnnotation);
        }
        return annotations;
    }

    private <T extends Annotation> T getGetterAnnotation(PropertyReference propertyReference, Class<T> annotationType) {
        Annotation annotation = null;
        PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(propertyReference.getBeanClass(), (String)propertyReference.getName());
        if (propertyDescriptor != null && this.includeGetter && propertyDescriptor.getReadMethod() != null) {
            annotation = AnnotationUtils.findAnnotation((Method)propertyDescriptor.getReadMethod(), annotationType);
        }
        return (T)annotation;
    }

    private <T extends Annotation> T getFieldAnnotation(PropertyReference propertyReference, Class<T> annotationType) {
        T annotation = null;
        Field field = ReflectionUtils.findField(propertyReference.getBeanClass(), (String)propertyReference.getName());
        if (field != null) {
            annotation = field.getAnnotation(annotationType);
        }
        return annotation;
    }

    public boolean hasAnnotation(PropertyReference propertyReference, Class<? extends Annotation> annotationType) {
        return this.findAnnotation(propertyReference, annotationType) != null;
    }
}

