/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.utils.bean;

import java.lang.reflect.Constructor;
import org.jarbframework.utils.Asserts;
import org.springframework.beans.BeanUtils;

public class BeanBuilder<T> {
    private final Constructor<T> constructor;

    public BeanBuilder(Constructor<T> constructor) {
        this.constructor = Asserts.notNull(constructor, "Constructor cannot be null");
    }

    public T instantiate(Object ... arguments) {
        Object[] invocationArguments = this.getInstantiationArguments(arguments);
        return (T)BeanUtils.instantiateClass(this.constructor, (Object[])invocationArguments);
    }

    private Object[] getInstantiationArguments(Object[] arguments) {
        Class<?>[] parameterTypes = this.constructor.getParameterTypes();
        Object[] invocationArguments = new Object[parameterTypes.length];
        for (int parameterIndex = 0; parameterIndex < parameterTypes.length; ++parameterIndex) {
            Class<?> parameterType = parameterTypes[parameterIndex];
            invocationArguments[parameterIndex] = this.findFirstOfType(parameterType, arguments);
        }
        return invocationArguments;
    }

    private Object findFirstOfType(Class<?> requiredType, Object[] values) {
        for (Object value : values) {
            if (!this.isOfType(value, requiredType)) continue;
            return value;
        }
        return null;
    }

    private boolean isOfType(Object value, Class<?> requiredType) {
        return value != null && requiredType.isAssignableFrom(value.getClass());
    }
}

