/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.utils.bean;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.jarbframework.utils.Asserts;
import org.jarbframework.utils.bean.PropertyReference;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ReflectionUtils;

public final class BeanProperties {
    public static Set<String> getPropertyNames(Class<?> beanClass) {
        HashSet<String> propertyNames = new HashSet<String>();
        for (PropertyDescriptor propertyDescriptor : BeanUtils.getPropertyDescriptors(beanClass)) {
            propertyNames.add(propertyDescriptor.getName());
        }
        propertyNames.addAll(BeanProperties.getFieldNames(beanClass));
        return propertyNames;
    }

    public static Set<String> getFieldNames(Class<?> beanClass) {
        final HashSet<String> fieldNames = new HashSet<String>();
        ReflectionUtils.doWithFields(beanClass, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalAccessException {
                fieldNames.add(field.getName());
            }
        });
        return fieldNames;
    }

    public static PropertyReference getFinalProperty(PropertyReference propertyReference) {
        if (propertyReference.isNestedProperty()) {
            Class<?> parentType = BeanProperties.getPropertyType(propertyReference.getParent());
            propertyReference = new PropertyReference(parentType, propertyReference.getSimpleName());
        }
        return propertyReference;
    }

    public static Class<?> getPropertyType(PropertyReference propertyReference) {
        return BeanProperties.findPropertyField(propertyReference).getType();
    }

    public static Class<?> getDeclaringClass(PropertyReference propertyReference) {
        return BeanProperties.findPropertyField(propertyReference).getDeclaringClass();
    }

    public static Field findPropertyField(PropertyReference propertyReference) {
        propertyReference = BeanProperties.getFinalProperty(propertyReference);
        Field field = ReflectionUtils.findField(propertyReference.getBeanClass(), (String)propertyReference.getName());
        return Asserts.notNull(field, "Could not find field '" + propertyReference.getName() + "' in '" + propertyReference.getBeanClass().getName() + "'.");
    }

    private BeanProperties() {
    }
}

