/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.utils.bean;

import org.jarbframework.utils.Asserts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.NullValueInNestedPathException;
import org.springframework.beans.PropertyAccessor;

public final class FlexibleBeanWrapper<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlexibleBeanWrapper.class);
    private final T bean;
    private final BeanWrapper beanWrapper;
    private final PropertyAccessor fieldAccessor;

    private FlexibleBeanWrapper(T bean) {
        this.bean = Asserts.notNull(bean, "Wrapped bean cannot be null.");
        this.beanWrapper = new BeanWrapperImpl(bean);
        this.fieldAccessor = new DirectFieldAccessor(bean);
    }

    public static <T> FlexibleBeanWrapper<T> wrap(T bean) {
        return new FlexibleBeanWrapper<T>(bean);
    }

    public static <T> FlexibleBeanWrapper<T> instantiate(Class<T> beanClass) {
        return FlexibleBeanWrapper.wrap(BeanUtils.instantiateClass(beanClass));
    }

    public boolean isReadableProperty(String propertyName) {
        return this.beanWrapper.isReadableProperty(propertyName) || this.fieldAccessor.isReadableProperty(propertyName);
    }

    public Object getPropertyValue(String propertyName) {
        if (this.beanWrapper.isReadableProperty(propertyName)) {
            return this.beanWrapper.getPropertyValue(propertyName);
        }
        return this.fieldAccessor.getPropertyValue(propertyName);
    }

    public Object getPropertyValueNullSafe(String propertyName) {
        Object value = null;
        try {
            value = this.getPropertyValue(propertyName);
        }
        catch (NullValueInNestedPathException e) {
            LOGGER.debug("Could not retrieve actual property value.", (Throwable)e);
        }
        return value;
    }

    public boolean isWritableProperty(String propertyName) {
        return this.beanWrapper.isWritableProperty(propertyName) || this.fieldAccessor.isWritableProperty(propertyName);
    }

    public FlexibleBeanWrapper<T> setPropertyValue(String propertyName, Object value) {
        if (this.beanWrapper.isWritableProperty(propertyName)) {
            this.beanWrapper.setPropertyValue(propertyName, value);
        } else {
            this.fieldAccessor.setPropertyValue(propertyName, value);
        }
        return this;
    }

    public T getWrappedBean() {
        return this.bean;
    }
}

