/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.utils.bean;

import org.jarbframework.utils.Asserts;
import org.jarbframework.utils.StringUtils;

public class PropertyReference {
    private static final String PROPERTY_SEPARATOR = ".";
    private final Class<?> beanClass;
    private final String name;

    public PropertyReference(Class<?> beanClass, String name) {
        this.beanClass = Asserts.notNull(beanClass, "Bean class is required");
        this.name = Asserts.hasText(name, "Property name is required");
    }

    public PropertyReference(PropertyReference parent, String name) {
        this(parent.getBeanClass(), parent.getName() + PROPERTY_SEPARATOR + name);
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        return this.isNestedProperty() ? StringUtils.substringAfterLast(this.name, PROPERTY_SEPARATOR) : this.name;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public boolean isNestedProperty() {
        return this.name.contains(PROPERTY_SEPARATOR);
    }

    public String getNestedName() {
        return this.isNestedProperty() ? StringUtils.substringAfter(this.name, PROPERTY_SEPARATOR) : this.name;
    }

    public PropertyReference getParent() {
        Asserts.state(this.isNestedProperty(), "Can only retrieve the parent for a nested property.");
        String parentName = StringUtils.substringBeforeLast(this.name, PROPERTY_SEPARATOR);
        return new PropertyReference(this.beanClass, parentName);
    }

    public String[] getPath() {
        return this.name.split("\\.");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PropertyReference)) {
            return false;
        }
        PropertyReference other = (PropertyReference)obj;
        return other.getBeanClass().equals(this.beanClass) && other.getName().equals(this.name);
    }

    public int hashCode() {
        return this.beanClass.hashCode() * this.name.hashCode();
    }

    public String toString() {
        return this.beanClass.getSimpleName() + PROPERTY_SEPARATOR + this.name;
    }
}

