/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.utils.orm;

import org.jarbframework.utils.Asserts;

public class ColumnReference {
    private String tableName;
    private String columnName;

    public ColumnReference(String tableName, String columnName) {
        this.tableName = Asserts.hasText(tableName, "Table name is required");
        this.columnName = Asserts.hasText(columnName, "Column name is required");
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColumnReference)) {
            return false;
        }
        ColumnReference other = (ColumnReference)obj;
        return other.getTableName().equals(this.tableName) && other.getColumnName().equals(this.columnName);
    }

    public int hashCode() {
        return this.tableName.hashCode() * this.columnName.hashCode();
    }

    public String toString() {
        return this.tableName + "." + this.columnName;
    }
}

