/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.utils.spring;

import org.jarbframework.utils.Asserts;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ClassUtils;

public abstract class AdvisorAddingBeanPostProcessor
extends ProxyConfig
implements BeanPostProcessor,
BeanClassLoaderAware {
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private Advisor advisor = null;
    private boolean addUpFront = false;

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setAdvisor(Advisor advisor) {
        this.advisor = advisor;
    }

    public void setAddUpFront(boolean addUpFront) {
        this.addUpFront = addUpFront;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        Asserts.state(this.advisor != null, "Cannot add a null pointer advisor to beans.");
        Object result = bean;
        if (!(bean instanceof AopInfrastructureBean) && AopUtils.canApply((Advisor)this.advisor, (Class)AopUtils.getTargetClass((Object)bean))) {
            if (bean instanceof Advised) {
                if (this.addUpFront) {
                    ((Advised)bean).addAdvisor(0, this.advisor);
                } else {
                    ((Advised)bean).addAdvisor(this.advisor);
                }
            } else {
                ProxyFactory proxyFactory = new ProxyFactory(bean);
                proxyFactory.copyFrom((ProxyConfig)this);
                proxyFactory.addAdvisor(this.advisor);
                result = proxyFactory.getProxy(this.beanClassLoader);
            }
        }
        return result;
    }
}

