/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.utils.spring;

import org.jarbframework.utils.Asserts;
import org.jarbframework.utils.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;

public class SpringBeanFinder {
    private final BeanFactory beanFactory;

    public SpringBeanFinder(BeanFactory beanFactory) {
        this.beanFactory = Asserts.notNull(beanFactory, "Bean factory cannot be null.");
    }

    public <T> T findBean(Class<T> beanClass, String identifier) {
        Asserts.notNull(beanClass, "Bean class cannot be null.");
        if (StringUtils.isNotBlank(identifier)) {
            return (T)this.beanFactory.getBean(identifier, beanClass);
        }
        return (T)this.beanFactory.getBean(beanClass);
    }

    public <T> T findUniqueBean(Class<T> beanClass, String fallbackIdentifier) {
        Asserts.hasText(fallbackIdentifier, "Fallback bean identifier cannot be empty.");
        try {
            return (T)this.beanFactory.getBean(beanClass);
        }
        catch (NoUniqueBeanDefinitionException be) {
            try {
                return (T)this.beanFactory.getBean(fallbackIdentifier, beanClass);
            }
            catch (BeansException dbe) {
                throw be;
            }
        }
    }
}

