/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.cassandra.jdbc;

import java.net.URI;
import java.net.URISyntaxException;
import org.javalite.common.Util;
import org.javalite.db_migrator.MigrationException;

public class CassandraURI {
    private static final String JDBC_PREFIX = "jdbc:";
    private final String keyspace;
    private final String configFile;

    public CassandraURI(String uriString) {
        try {
            if (!uriString.startsWith(JDBC_PREFIX)) {
                throw new MigrationException("must start with jdbc:");
            }
            URI uri = new URI(uriString.substring(5).replaceAll("\\\\", "/"));
            if (!"cassandra".equalsIgnoreCase(uri.getScheme())) {
                throw new MigrationException("must use protocol: cassandra");
            }
            if (!Util.blank((Object)uri.getHost())) {
                throw new MigrationException("host should be blank");
            }
            String query = uri.getQuery();
            if (Util.blank((Object)query)) {
                throw new MigrationException("query is missing");
            }
            if (!query.contains("=")) {
                throw new MigrationException("query malformed");
            }
            if (query.indexOf("=") != query.lastIndexOf("=")) {
                throw new MigrationException("query should have just one parameter");
            }
            String[] parts = Util.split((String)query, (char)'=');
            if (!parts[0].equals("config_file")) {
                throw new MigrationException("query has a wrong parameter");
            }
            this.keyspace = uri.getRawPath().substring(1);
            this.configFile = parts[1];
        }
        catch (URISyntaxException e) {
            throw new MigrationException(e);
        }
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public String getConfigFile() {
        return this.configFile;
    }
}

