/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.db_migrator;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.javalite.common.Util;
import org.javalite.db_migrator.DbUtils;
import org.javalite.db_migrator.Migration;
import org.javalite.db_migrator.MigrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLMigration
extends Migration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLMigration.class);
    private static final String DEFAULT_DELIMITER = ";";
    private static final String DELIMITER_KEYWORD = "DELIMITER";
    private static final String[] COMMENT_CHARS = new String[]{"--", "#", "//"};

    public SQLMigration(String version, File migrationFile) {
        super(version, migrationFile);
    }

    @Override
    void migrate(String encoding) {
        try {
            String path = this.getMigrationFile().getCanonicalPath();
            Charset charset = encoding != null ? Charset.forName(encoding) : Charset.defaultCharset();
            LOGGER.info("Reading file {} using charset: {} ", (Object)path, (Object)charset);
            List<String> lines = Files.readAllLines(Paths.get(path, new String[0]), charset);
            String delimiter = DEFAULT_DELIMITER;
            ArrayList<String> statements = new ArrayList<String>();
            StringBuilder currentStatement = new StringBuilder();
            for (String line : lines) {
                if (this.commentLine(line = line.trim()) || Util.blank((Object)line)) continue;
                if (line.startsWith(DELIMITER_KEYWORD)) {
                    delimiter = line.substring(10).trim();
                    continue;
                }
                if (line.endsWith(delimiter)) {
                    currentStatement.append(line.substring(0, line.length() - delimiter.length()));
                    if (!Util.blank((Object)currentStatement.toString())) {
                        statements.add(currentStatement.toString());
                    }
                    currentStatement = new StringBuilder();
                    continue;
                }
                currentStatement.append(line).append(System.getProperty("line.separator"));
            }
            if (!Util.blank((Object)currentStatement.toString())) {
                statements.add(currentStatement.toString());
            }
            for (String statement : statements) {
                DbUtils.exec(statement, new Object[0]);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error executing migration file: {}", (Object)this.getMigrationFile().toString(), (Object)e);
            throw new MigrationException(e);
        }
    }

    private boolean commentLine(String line) {
        for (String cc : COMMENT_CHARS) {
            if (!line.trim().startsWith(cc)) continue;
            return true;
        }
        return false;
    }
}

