/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.db_migrator.maven;

import org.apache.maven.plugin.MojoExecutionException;
import org.javalite.activejdbc.Base;
import org.javalite.db_migrator.DbUtils;
import org.javalite.db_migrator.MigrationManager;
import org.javalite.db_migrator.maven.AbstractDbMigrationMojo;

public class CreateMojo
extends AbstractDbMigrationMojo {
    @Override
    public void executeMojo() throws MojoExecutionException {
        Object databaseName = DbUtils.extractDatabaseName(this.getUrl());
        try {
            String createSql = DbUtils.blank(this.getCreateSql()) ? "create database %s" : this.getCreateSql();
            switch (DbUtils.databaseType(this.getUrl())) {
                case MYSQL: {
                    break;
                }
                case SQL_SERVER: {
                    break;
                }
                case POSTGRESQL: {
                    databaseName = "\"" + (String)databaseName + "\"";
                }
            }
            this.openConnection(true);
            DbUtils.exec(String.format(createSql, databaseName), new Object[0]);
            this.getLog().info((CharSequence)("Created database " + this.getUrl()));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create database: " + this.getUrl(), e);
        }
        finally {
            Base.close();
        }
        try {
            this.openConnection();
            new MigrationManager(this.getMigrationsPath(), this.getUrl()).createSchemaVersionTableIfDoesNotExist();
        }
        catch (Exception e) {
            throw new MojoExecutionException("failed to create SCHEMA_VERSION table", e);
        }
        finally {
            Base.close();
        }
    }
}

