/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.async;

import com.google.inject.Injector;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.management.impl.ActiveMQServerControlImpl;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.javalite.async.AsyncException;
import org.javalite.async.BatchReceiver;
import org.javalite.async.Command;
import org.javalite.async.CommandListener;
import org.javalite.async.QueueConfig;
import org.javalite.async.SessionPool;
import org.javalite.common.Collections;
import org.javalite.common.JsonHelper;
import org.javalite.common.Util;
import org.javalite.common.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Async {
    private static final Logger LOGGER = LoggerFactory.getLogger(Async.class);
    private static final int MIN_LARGE_MESSAGE_SIZE = 819200;
    private static final String QUEUE_NAMESPACE = "queue/";
    private Injector injector;
    private final Configuration config = new ConfigurationImpl();
    private Connection consumerConnection;
    private Connection producerConnection;
    private EmbeddedActiveMQ artemisServer;
    private boolean binaryMode;
    private List<QueueConfig> queueConfigsList = new ArrayList<QueueConfig>();
    private boolean started;
    private InitialContext initialContext;
    private ActiveMQConnectionFactory connectionFactory;
    private List<Session> listenerSessions = new ArrayList<Session>();
    private List<MessageConsumer> listenerConsumers = new ArrayList<MessageConsumer>();
    private SessionPool senderSessionPool;
    private SessionPool receiverSessionPool;

    public Async(String dataDirectory, boolean useLibAio, QueueConfig ... queueConfigs) {
        this(dataDirectory, useLibAio, (Injector)null, queueConfigs);
    }

    public Async(String dataDirectory, boolean useLibAio, Injector injector, QueueConfig ... queueConfigs) {
        try {
            this.injector = injector;
            java.util.Collections.addAll(this.queueConfigsList, queueConfigs);
            this.configureLocations(dataDirectory);
            this.configureAcceptor();
            this.configurePaging();
            this.configureQueues(queueConfigs);
            this.configureJournal(useLibAio);
            this.config.setThreadPoolMaxSize(-1);
            this.config.setGracefulShutdownEnabled(true);
            this.config.setScheduledThreadPoolMaxSize(10);
        }
        catch (AsyncException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AsyncException("Failed to start EmbeddedJMS", e);
        }
    }

    private void configureJournal(boolean useLibAio) {
        this.config.setJournalType(useLibAio ? JournalType.ASYNCIO : JournalType.NIO);
        this.config.setJournalBufferSize_AIO(819200);
        this.config.setJournalBufferSize_NIO(819200);
    }

    private void configureLocations(String dataDirectory) {
        if (dataDirectory == null || !new File(dataDirectory).exists()) {
            throw new AsyncException("Must provide data directory that exists");
        }
        this.config.setBindingsDirectory(dataDirectory + "/bindings");
        this.config.setJournalDirectory(dataDirectory + "/journal");
        this.config.setLargeMessagesDirectory(dataDirectory + "/largemessages");
        this.config.setPagingDirectory(dataDirectory + "/paging");
    }

    private void configureAcceptor() {
        this.config.setPersistenceEnabled(true);
        this.config.setSecurityEnabled(false);
        this.config.getAcceptorConfigurations().add(new TransportConfiguration(InVMAcceptorFactory.class.getName()));
        this.config.getConnectorConfigurations().put("connector", new TransportConfiguration(InVMConnectorFactory.class.getName()));
    }

    private void configurePaging() {
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        addressSettings.setMaxSizeBytes(0x1E00000L);
        addressSettings.setPageSizeBytes(0xA00000);
        addressSettings.setPageCacheMaxSize(20);
        this.config.getAddressesSettings().put("jms.queue.*", addressSettings);
    }

    public void start() {
        try {
            this.artemisServer = new EmbeddedActiveMQ();
            this.artemisServer.setConfiguration(this.config);
            this.artemisServer.start();
            this.artemisServer.getActiveMQServer().getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoCreateQueues(Boolean.valueOf(false)).setAutoCreateAddresses(Boolean.valueOf(false)).setAutoDeleteQueues(Boolean.valueOf(false)).setAutoDeleteAddresses(Boolean.valueOf(false)));
            Wait.waitFor(() -> this.artemisServer.getActiveMQServer().isStarted());
            this.connectionFactory = new ActiveMQConnectionFactory("vm://0");
            this.consumerConnection = this.connectionFactory.createConnection();
            this.receiverSessionPool = new SessionPool("Consumer", this.consumerConnection);
            this.producerConnection = this.connectionFactory.createConnection();
            this.senderSessionPool = new SessionPool("Producer", this.producerConnection);
            this.configureListeners(this.injector, this.queueConfigsList);
            this.started = true;
        }
        catch (Exception e) {
            throw new AsyncException(e);
        }
    }

    public void stop() {
        this.started = false;
        this.senderSessionPool.close();
        this.receiverSessionPool.close();
        this.listenerConsumers.forEach(Util::closeQuietly);
        this.listenerSessions.forEach(Util::closeQuietly);
        this.connectionFactory.close();
        Util.closeQuietly((AutoCloseable)this.producerConnection);
        Util.closeQuietly((AutoCloseable)this.consumerConnection);
        try {
            String[] remoteAddresses;
            ActiveMQServerControlImpl control = this.artemisServer.getActiveMQServer().getActiveMQServerControl();
            for (String address : remoteAddresses = control.listRemoteAddresses()) {
                control.closeConnectionsForAddress(address);
            }
        }
        catch (Exception e) {
            LOGGER.warn("exception trying to close remote connections.", (Throwable)e);
        }
        try {
            this.artemisServer.stop();
            Wait.waitFor(() -> this.artemisServer.getActiveMQServer().getState() == ActiveMQServer.SERVER_STATE.STOPPED);
        }
        catch (Exception e) {
            LOGGER.warn("exception trying to stop broker.", (Throwable)e);
        }
    }

    private void checkInRange(int value, int min, int max, String name) {
        if (value < min || value > max) {
            throw new AsyncException("incorrect " + name + " value");
        }
    }

    private void checkStarted() {
        if (!this.started) {
            throw new AsyncException("Server not started.");
        }
    }

    private void configureQueues(QueueConfig ... queueConfigs) throws NamingException {
        Hashtable<Object, String> jndi = new Hashtable<Object, String>();
        jndi.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
        for (QueueConfig queueConfig : queueConfigs) {
            QueueConfiguration queueConfiguration = new QueueConfiguration(queueConfig.getName());
            queueConfiguration.setDurable(Boolean.valueOf(queueConfig.isDurable())).setAddress(queueConfig.getName()).setRoutingType(RoutingType.ANYCAST);
            this.config.addQueueConfiguration(queueConfiguration);
            jndi.put("queue.queue/" + queueConfig.getName(), queueConfig.getName());
        }
        this.initialContext = new InitialContext(jndi);
    }

    private void configureListeners(Injector injector, List<QueueConfig> queueConfigs) throws JMSException {
        for (QueueConfig queueConfig : queueConfigs) {
            CommandListener listener = queueConfig.getCommandListener();
            if (listener == null) continue;
            listener.setInjector(injector);
            if (injector != null) {
                injector.injectMembers((Object)listener);
            }
            for (int i = 0; i < queueConfig.getListenerCount(); ++i) {
                Session session = this.consumerConnection.createSession(false, 1);
                Queue queue = session.createQueue(queueConfig.getName());
                MessageConsumer consumer = session.createConsumer((Destination)queue);
                consumer.setMessageListener((MessageListener)listener);
                this.listenerSessions.add(session);
                this.listenerConsumers.add(consumer);
            }
        }
        this.consumerConnection.start();
    }

    public void setBinaryMode(boolean binaryMode) {
        this.binaryMode = binaryMode;
    }

    public void configureNetty(String host, int port) {
        Map params = Collections.map((Object[])new Object[]{"host", host, "port", port});
        this.config.getAcceptorConfigurations().add(new TransportConfiguration(NettyAcceptorFactory.class.getName(), params));
    }

    public void send(String queueName, Command command) {
        this.send(queueName, command, 1, 4, 0L);
    }

    public void send(String queueName, Command command, Date deliveryTime) {
        this.send(queueName, command, 1, 4, 0L, deliveryTime == null ? -1L : deliveryTime.getTime());
    }

    public void send(String queueName, Command command, int deliveryMode) {
        this.send(queueName, command, deliveryMode, 4, 0L);
    }

    public void send(String queueName, Command command, int deliveryMode, long deliveryTime) {
        this.send(queueName, command, deliveryMode, 4, 0L, deliveryTime);
    }

    public void send(String queueName, Command command, int deliveryMode, int priority, long timeToLive) {
        this.send(queueName, command, deliveryMode, priority, timeToLive, -1L);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(String queueName, Command command, int deliveryMode, int priority, long timeToLive, long deliveryTime) {
        this.checkStarted();
        long now = System.currentTimeMillis();
        try (Session session = this.senderSessionPool.getSession();){
            TextMessage message;
            this.checkInRange(deliveryMode, 1, 2, "delivery mode");
            this.checkInRange(priority, 0, 9, "priority");
            if (timeToLive < 0L) {
                throw new AsyncException("time to live cannot be negative");
            }
            Queue queue = (Queue)this.initialContext.lookup(QUEUE_NAMESPACE + queueName);
            if (queue == null) {
                throw new AsyncException("Failed to find queue: " + queueName);
            }
            if (this.binaryMode) {
                BytesMessage msg = session.createBytesMessage();
                msg.writeBytes(command.toBytes());
                message = msg;
            } else {
                message = session.createTextMessage(command.toXml());
            }
            if (deliveryTime > 0L) {
                message.setLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME.toString(), deliveryTime);
            }
            try (MessageProducer producer = session.createProducer((Destination)queue);){
                producer.send((javax.jms.Message)message, deliveryMode, priority, timeToLive);
            }
        }
        catch (AsyncException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new AsyncException("Failed to send message", e2);
                }
            }
            catch (Throwable throwable) {
                LOGGER.debug(JsonHelper.toJsonString((Object)Collections.map((Object[])new Object[]{"message", "completed sending command", "time_millis", now - System.currentTimeMillis(), "command", command.getClass(), "queue", queueName})));
                throw throwable;
            }
        }
        LOGGER.debug(JsonHelper.toJsonString((Object)Collections.map((Object[])new Object[]{"message", "completed sending command", "time_millis", now - System.currentTimeMillis(), "command", command.getClass(), "queue", queueName})));
    }

    public Command receiveCommand(String queueName) {
        return this.receiveCommand(queueName, 0L);
    }

    public <T extends Command> T receiveCommand(String queueName, Class<T> type) {
        return (T)this.receiveCommand(queueName, 0L);
    }

    public <T extends Command> T receiveCommand(String queueName, int timeout, Class<T> type) {
        return (T)this.receiveCommand(queueName, timeout);
    }

    public Command receiveCommand(String queueName, long timeout) {
        try {
            javax.jms.Message message = this.receiveMessage(queueName, timeout);
            if (message == null) {
                return null;
            }
            Object command = this.binaryMode ? Command.fromBytes(Async.getBytes((BytesMessage)message)) : Command.fromXml(((TextMessage)message).getText());
            ((Command)command).setJMSMessageID(message.getJMSMessageID());
            return command;
        }
        catch (Exception e) {
            throw new AsyncException("Could not get command", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public javax.jms.Message receiveMessage(String queueName, long timeout) {
        this.checkStarted();
        try (Session session = this.receiverSessionPool.getSession();){
            javax.jms.Message message;
            block14: {
                MessageConsumer consumer = session.createConsumer((Destination)this.lookupQueue(queueName));
                try {
                    message = consumer.receive(timeout);
                    if (consumer == null) break block14;
                }
                catch (Throwable throwable) {
                    if (consumer != null) {
                        try {
                            consumer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                consumer.close();
            }
            return message;
        }
        catch (Exception e) {
            throw new AsyncException("Could not get message", e);
        }
    }

    public void sendTextMessage(String queueName, String text) {
        this.sendTextMessage(queueName, text, 1, 4, 0L, -1L);
    }

    public void sendTextMessage(String queueName, String text, long deliveryTime) {
        this.sendTextMessage(queueName, text, 1, 4, 0L, deliveryTime);
    }

    public void sendTextMessage(String queueName, String text, int deliveryMode, int priority, long timeToLive) {
        this.sendTextMessage(queueName, text, deliveryMode, priority, timeToLive, -1L);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendTextMessage(String queueName, String text, int deliveryMode, int priority, long timeToLive, long deliveryTime) {
        this.checkStarted();
        long now = System.currentTimeMillis();
        try (Session session = this.producerConnection.createSession();){
            this.checkInRange(deliveryMode, 1, 2, "delivery mode");
            this.checkInRange(priority, 0, 9, "priority");
            if (timeToLive < 0L) {
                throw new AsyncException("time to live cannot be negative");
            }
            TextMessage message = session.createTextMessage(text);
            if (deliveryTime > 0L) {
                message.setLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME.toString(), deliveryTime);
            }
            MessageProducer p = session.createProducer((Destination)this.lookupQueue(queueName));
            p.send((javax.jms.Message)message, deliveryMode, priority, timeToLive);
        }
        catch (AsyncException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new AsyncException("Failed to send message", e2);
                }
            }
            catch (Throwable throwable) {
                LOGGER.debug(JsonHelper.toJsonString((Object)Collections.map((Object[])new Object[]{"message", "completed sending text message", "time_millis", now - System.currentTimeMillis(), "queue", queueName})));
                throw throwable;
            }
        }
        LOGGER.debug(JsonHelper.toJsonString((Object)Collections.map((Object[])new Object[]{"message", "completed sending text message", "time_millis", now - System.currentTimeMillis(), "queue", queueName})));
    }

    public BatchReceiver getBatchReceiver(String queueName, long timeout) {
        try {
            return new BatchReceiver(queueName, timeout, this.consumerConnection);
        }
        catch (Exception e) {
            throw new AsyncException(e);
        }
    }

    public List<Command> getTopCommands(int count, String queueName) {
        ArrayList<Command> arrayList;
        block9: {
            this.checkStarted();
            ArrayList<Command> res = new ArrayList<Command>();
            Session session = this.consumerConnection.createSession();
            try {
                Enumeration messages = session.createBrowser(this.lookupQueue(queueName)).getEnumeration();
                for (int i = 0; i < count && messages.hasMoreElements(); ++i) {
                    javax.jms.Message message = (javax.jms.Message)messages.nextElement();
                    Object command = this.binaryMode ? Command.fromBytes(Async.getBytes((BytesMessage)message)) : Command.fromXml(((TextMessage)message).getText());
                    ((Command)command).setJMSMessageID(message.getJMSMessageID());
                    res.add((Command)command);
                }
                arrayList = res;
                if (session == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AsyncException("Could not lookup commands", e);
                }
            }
            session.close();
        }
        return arrayList;
    }

    public List<String> getTopTextMessages(int maxSize, String queueName) {
        ArrayList<String> arrayList;
        block9: {
            this.checkStarted();
            ArrayList<String> res = new ArrayList<String>();
            Session session = this.consumerConnection.createSession();
            try {
                Enumeration messages = session.createBrowser(this.lookupQueue(queueName)).getEnumeration();
                for (int i = 0; i < maxSize && messages.hasMoreElements(); ++i) {
                    TextMessage message = (TextMessage)messages.nextElement();
                    res.add(message.getText());
                }
                arrayList = res;
                if (session == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AsyncException("Could not lookup messages", e);
                }
            }
            session.close();
        }
        return arrayList;
    }

    private Queue lookupQueue(String queueName) throws NamingException {
        return (Queue)this.initialContext.lookup(QUEUE_NAMESPACE + queueName);
    }

    javax.jms.Message lookupMessage(String queueName) {
        javax.jms.Message message;
        block9: {
            this.checkStarted();
            Session session = this.consumerConnection.createSession();
            try {
                Enumeration messages = session.createBrowser(this.lookupQueue(queueName)).getEnumeration();
                message = (javax.jms.Message)messages.nextElement();
                if (session == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchElementException e) {
                    return null;
                }
                catch (Exception e) {
                    throw new AsyncException("Lookup failed", e);
                }
            }
            session.close();
        }
        return message;
    }

    public static byte[] getBytes(BytesMessage message) throws JMSException {
        int len = (int)message.getBodyLength();
        byte[] bytes = new byte[len];
        message.readBytes(bytes, len);
        return bytes;
    }

    private QueueControl getQueueControl(String queueName) {
        this.checkStarted();
        for (Object resource : this.artemisServer.getActiveMQServer().getManagementService().getResources(QueueControl.class)) {
            if (!(resource instanceof QueueControl) || !((QueueControl)resource).getName().equals(queueName)) continue;
            return (QueueControl)resource;
        }
        throw new AsyncException("Failed to find queue: " + queueName);
    }

    public Map<String, Long> getMessageCounts() {
        HashMap<String, Long> counts = new HashMap<String, Long>();
        for (QueueConfig queueConfig : this.queueConfigsList) {
            counts.put(queueConfig.getName(), this.getMessageCount(queueConfig.getName()));
        }
        return counts;
    }

    public long getMessageCount(String queue) {
        try {
            return this.getQueueControl(queue).getMessageCount();
        }
        catch (Exception e) {
            throw new AsyncException(e);
        }
    }

    public void resume(String queueName) {
        try {
            this.getQueueControl(queueName).resume();
        }
        catch (Exception e) {
            throw new AsyncException(e);
        }
    }

    public void pause(String queueName) {
        try {
            this.getQueueControl(queueName).pause();
        }
        catch (Exception e) {
            throw new AsyncException(e);
        }
    }

    public boolean isPaused(String queueName) {
        try {
            return this.getQueueControl(queueName).isPaused();
        }
        catch (Exception e) {
            throw new AsyncException(e);
        }
    }

    public int removeMessages(String queueName, String filter) {
        try {
            return this.getQueueControl(queueName).removeMessages(filter);
        }
        catch (Exception e) {
            throw new AsyncException(e);
        }
    }

    public int removeAllMessages(String queueName) {
        try {
            return this.getQueueControl(queueName).removeMessages(null);
        }
        catch (Exception e) {
            throw new AsyncException(e);
        }
    }

    public int moveMessages(String source, String target) {
        try {
            return this.getQueueControl(source).moveMessages("", target);
        }
        catch (Exception e) {
            throw new AsyncException(e);
        }
    }

    public boolean moveMessage(String jmsMessageId, String source, String target) {
        try {
            return this.getQueueControl(source).moveMessages("AMQUserID='" + jmsMessageId + "'", target) == 1;
        }
        catch (Exception e) {
            throw new AsyncException(e);
        }
    }

    public Configuration getConfig() {
        return this.config;
    }
}

