/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.async;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.javalite.async.AsyncException;
import org.javalite.common.Util;

public class BatchReceiver
implements Closeable {
    private long timeout;
    private Session session;
    private MessageConsumer consumer;

    protected BatchReceiver(String queueName, long timeout, Connection connection) throws JMSException {
        this.timeout = timeout;
        this.session = connection.createSession(true, 0);
        Queue queue = this.session.createQueue(queueName);
        this.consumer = this.session.createConsumer((Destination)queue);
    }

    public List<String> receiveTextMessages(int maxSize) {
        ArrayList<String> messages = new ArrayList<String>();
        try {
            while (messages.size() <= maxSize) {
                TextMessage message = (TextMessage)this.consumer.receive(this.timeout);
                if (message == null) {
                    return messages;
                }
                messages.add(message.getText());
            }
        }
        catch (JMSException e) {
            throw new AsyncException(e);
        }
        return messages;
    }

    public void commit() {
        try {
            this.session.commit();
        }
        catch (JMSException e) {
            throw new AsyncException(e);
        }
    }

    public void rollback() {
        try {
            this.session.rollback();
        }
        catch (JMSException e) {
            throw new AsyncException(e);
        }
    }

    @Override
    public void close() {
        Util.closeQuietly((AutoCloseable)this.session);
    }
}

