/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.async;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.javalite.async.AsyncException;
import org.javalite.async.CDATAXppDriver;
import org.javalite.common.Collections;

public abstract class Command {
    private String jmsMessageId;
    private Map<String, String> params = Collections.map((Object[])new Object[]{"class", this.getClass().getSimpleName()});
    private static final XStream X_STREAM = new XStream((HierarchicalStreamDriver)new CDATAXppDriver());

    public static <T extends Command> T fromXml(String commandXml) {
        return (T)((Command)X_STREAM.fromXML(commandXml));
    }

    public abstract void execute();

    public final String toXml() {
        return X_STREAM.toXML((Object)this);
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ZipOutputStream stream = new ZipOutputStream(bout);
        ZipEntry ze = new ZipEntry("async_message");
        stream.putNextEntry(ze);
        stream.write(this.toXml().getBytes());
        stream.flush();
        stream.close();
        return bout.toByteArray();
    }

    public static <T extends Command> T fromBytes(byte[] bytes) throws IOException {
        int len;
        ZipInputStream zin = new ZipInputStream(new ByteArrayInputStream(bytes));
        ZipEntry ze = zin.getNextEntry();
        if (ze == null) {
            throw new AsyncException("something is seriously wrong with serialization");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        while ((len = zin.read(buffer)) != -1) {
            bout.write(buffer, 0, len);
        }
        return Command.fromXml(bout.toString());
    }

    public String getJMSMessageID() {
        return this.jmsMessageId;
    }

    public void setJMSMessageID(String jmsMessageId) {
        this.jmsMessageId = jmsMessageId;
    }
}

