/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.async;

import com.google.inject.Injector;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.javalite.async.Async;
import org.javalite.async.AsyncException;
import org.javalite.async.Command;
import org.javalite.common.Collections;
import org.javalite.common.JsonHelper;
import org.javalite.logging.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandListener
implements MessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandListener.class);
    private Injector injector;

    public void onMessage(Message message) {
        Context.clear();
        try {
            Command command = this.parseCommand(message);
            command.setJMSMessageID(message.getJMSMessageID());
            if (this.injector != null) {
                this.injector.injectMembers((Object)command);
            }
            long start = System.currentTimeMillis();
            this.onCommand(command);
            LOGGER.info(JsonHelper.toJsonString((Object)Collections.map((Object[])new Object[]{"processed_millis", System.currentTimeMillis() - start, "command", command.getClass().getSimpleName()})));
        }
        catch (Exception e) {
            LOGGER.error("Failed to process message: {}", (Object)this.getCommandAsText(message), (Object)e);
            throw new AsyncException("Failed to process message", e);
        }
        finally {
            Context.clear();
        }
    }

    private String getCommandAsText(Message message) {
        try {
            if (message instanceof BytesMessage) {
                return new String(Async.getBytes((BytesMessage)message));
            }
            if (message instanceof TextMessage) {
                return ((TextMessage)message).getText();
            }
            return "Failed to convert message to text: " + message.toString();
        }
        catch (Exception e) {
            LOGGER.error("Failed to convert message to text: " + message.toString());
            return "failed to convert message to text: " + message.toString();
        }
    }

    public <T extends Command> void onCommand(T command) {
        command.execute();
    }

    void setInjector(Injector injector) {
        this.injector = injector;
    }

    protected Command parseCommand(Message message) throws IOException, JMSException {
        Object command;
        if (message instanceof TextMessage) {
            command = Command.fromXml(((TextMessage)message).getText());
        } else {
            byte[] bytes = Async.getBytes((BytesMessage)message);
            command = Command.fromBytes(bytes);
        }
        return command;
    }
}

