/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.async;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.javalite.async.SessionPool;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PooledSession
implements Session {
    private static Logger LOGGER = LoggerFactory.getLogger(PooledSession.class);
    private Session session;
    private SessionPool sessionPool;
    private long lastUsed;

    protected PooledSession(Session session, SessionPool sessionPool) {
        this.session = session;
        this.sessionPool = sessionPool;
        LOGGER.debug("Created session: " + this);
    }

    public void close() throws JMSException {
        LOGGER.debug("Closing session: " + this);
        this.sessionPool.reclaim(this);
    }

    protected void markLastUsedTime() {
        this.lastUsed = System.currentTimeMillis();
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    protected void reallyClose() {
        Util.closeQuietly((AutoCloseable)this.session);
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.session.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.session.createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.session.createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.session.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return null;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.session.createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.session.createTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        return this.session.createTextMessage(text);
    }

    public boolean getTransacted() throws JMSException {
        return this.session.getTransacted();
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.session.getAcknowledgeMode();
    }

    public void commit() throws JMSException {
        this.session.commit();
    }

    public void rollback() throws JMSException {
        this.session.rollback();
    }

    public void recover() throws JMSException {
        this.session.recover();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.session.getMessageListener();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.session.setMessageListener(listener);
    }

    public void run() {
        this.session.run();
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        return this.session.createProducer(destination);
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.session.createConsumer(destination);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.session.createConsumer(destination, messageSelector);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        return this.session.createConsumer(destination, messageSelector, noLocal);
    }

    public Queue createQueue(String queueName) throws JMSException {
        return this.session.createQueue(queueName);
    }

    public Topic createTopic(String topicName) throws JMSException {
        return this.session.createTopic(topicName);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.session.createDurableSubscriber(topic, name);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return this.session.createDurableSubscriber(topic, name, messageSelector, noLocal);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.session.createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        return this.session.createBrowser(queue, messageSelector);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.session.createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.session.createTemporaryTopic();
    }

    public void unsubscribe(String name) throws JMSException {
        this.session.unsubscribe(name);
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
        return this.session.createSharedConsumer(topic, sharedSubscriptionName);
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSException {
        return this.session.createSharedConsumer(topic, sharedSubscriptionName, messageSelector);
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        return this.session.createDurableConsumer(topic, name);
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return this.session.createDurableConsumer(topic, name, messageSelector, noLocal);
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        return this.session.createSharedDurableConsumer(topic, name);
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        return this.session.createSharedDurableConsumer(topic, name, messageSelector);
    }
}

