/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.async;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import org.javalite.async.AsyncException;
import org.javalite.async.PooledSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionPool {
    private final Logger LOGGER;
    private static final int MAX_AGE_MILLIS = 5000;
    private final LinkedList<PooledSession> sessions = new LinkedList();
    private final Connection connection;
    private boolean closed = false;
    private final SessionCleaner sessionCleaner = new SessionCleaner();

    public SessionPool(String name, Connection connection) {
        this.connection = connection;
        this.LOGGER = LoggerFactory.getLogger((String)("SessionPool: " + name));
        this.sessionCleaner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession() throws JMSException {
        Session session;
        if (this.closed) {
            throw new AsyncException("pool already closed!");
        }
        LinkedList<PooledSession> linkedList = this.sessions;
        synchronized (linkedList) {
            session = this.sessions.poll();
        }
        if (session != null) {
            this.LOGGER.debug("Found existing session: " + session + ". Pool size: " + this.sessions.size());
            return session;
        }
        session = this.createNewSession();
        this.LOGGER.debug("Created new session: " + session + ". Pool size: " + this.sessions.size());
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LinkedList<PooledSession> linkedList = this.sessions;
        synchronized (linkedList) {
            this.closed = true;
            this.sessionCleaner.close();
            this.sessions.stream().forEach(PooledSession::reallyClose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reclaim(PooledSession session) {
        session.markLastUsedTime();
        LinkedList<PooledSession> linkedList = this.sessions;
        synchronized (linkedList) {
            this.sessions.add(session);
        }
        this.LOGGER.debug("Reclaimed session: " + session);
    }

    public Session createNewSession() throws JMSException {
        return new PooledSession(this.connection.createSession(), this);
    }

    private class SessionCleaner {
        private final ScheduledExecutorService cleanupExecutor = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("SessionCleaner Thread");
            thread.setDaemon(true);
            return thread;
        });
        private Runnable command = () -> {
            SessionPool.this.LOGGER.debug("Checking stale sessions...");
            try {
                LinkedList<PooledSession> linkedList = SessionPool.this.sessions;
                synchronized (linkedList) {
                    if (!SessionPool.this.sessions.isEmpty()) {
                        Iterator iterator = SessionPool.this.sessions.iterator();
                        while (iterator.hasNext()) {
                            PooledSession session = (PooledSession)iterator.next();
                            long ageMillis = System.currentTimeMillis() - session.getLastUsed();
                            if (ageMillis <= 5000L) break;
                            session.reallyClose();
                            iterator.remove();
                            SessionPool.this.LOGGER.debug("Session is " + ageMillis + " milliseconds old, closing: " + session);
                        }
                    }
                }
            }
            catch (Exception e) {
                SessionPool.this.LOGGER.error("Failed to close sessions!", (Throwable)e);
            }
        };

        private SessionCleaner() {
        }

        protected void close() {
            this.cleanupExecutor.shutdown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void start() {
            LinkedList<PooledSession> linkedList = SessionPool.this.sessions;
            synchronized (linkedList) {
                this.cleanupExecutor.scheduleAtFixedRate(this.command, 5L, 5L, TimeUnit.SECONDS);
                SessionPool.this.LOGGER.debug("Starting to clean stale sessions...");
            }
        }
    }
}

