/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.examples;

import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.javasimon.utils.SimonUtils;

public final class ManagerVsStopwatchComparison {
    private static final int LOOP = 10000000;
    private static final String NAME = SimonUtils.generateNameForClass((String)"-stopwatch");

    private ManagerVsStopwatchComparison() {
    }

    public static void main(String[] args) {
        String name = NAME;
        for (int i = 0; i < 100000; ++i) {
            name = Long.toHexString((long)(Math.random() * 9.223372036854776E18));
            SimonManager.getStopwatch((String)name);
        }
        System.out.println("Manager initialized");
        Stopwatch tested = SimonManager.getStopwatch((String)name);
        ManagerVsStopwatchComparison.getStartStopTest(name);
        System.out.println("Warm-up complete");
        Stopwatch stopwatch = SimonManager.getStopwatch(null);
        Split split = stopwatch.start();
        ManagerVsStopwatchComparison.getStopwatchTest(name);
        System.out.println("\ngetStopwatch: " + SimonUtils.presentNanoTime((long)split.stop().runningFor()));
        tested.reset();
        split = stopwatch.reset().start();
        ManagerVsStopwatchComparison.startStopTest(tested);
        System.out.println("\nstart/stop: " + SimonUtils.presentNanoTime((long)split.stop().runningFor()));
        System.out.println("Stopwatch: " + tested);
        tested.reset();
        split = stopwatch.reset().start();
        ManagerVsStopwatchComparison.getStartStopTest(name);
        System.out.println("\nget+start/stop: " + SimonUtils.presentNanoTime((long)split.stop().runningFor()));
        System.out.println("Stopwatch: " + tested);
        SimonManager.clear();
        tested = SimonManager.getStopwatch((String)name);
        tested.reset();
        split = stopwatch.reset().start();
        ManagerVsStopwatchComparison.getStartStopTest(name);
        System.out.println("\nget+start/stop after SM clear: " + SimonUtils.presentNanoTime((long)split.stop().runningFor()));
        System.out.println("Stopwatch: " + tested);
    }

    private static void getStopwatchTest(String name) {
        for (int i = 0; i < 10000000; ++i) {
            SimonManager.getStopwatch((String)name);
        }
    }

    private static void startStopTest(Stopwatch stopwatch) {
        for (int i = 0; i < 10000000; ++i) {
            stopwatch.start().stop();
        }
    }

    private static void getStartStopTest(String name) {
        for (int i = 0; i < 10000000; ++i) {
            SimonManager.getStopwatch((String)name).start().stop();
        }
    }
}

