/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.examples;

import java.util.concurrent.CountDownLatch;
import org.javasimon.SimonManager;
import org.javasimon.Stopwatch;
import org.javasimon.utils.SimonUtils;

class MultithreadedTester
extends Thread {
    private static final String NAME = SimonUtils.generateName();
    private static final int TOTAL = 10000000;
    private final int threads;
    private final int loop;
    private final CountDownLatch latch;

    MultithreadedTester(int threads) {
        System.out.println("Creating Multithreaded test for " + threads + " threads");
        this.threads = threads;
        this.loop = 10000000 / threads;
        this.latch = new CountDownLatch(threads);
    }

    void execute() throws InterruptedException {
        Stopwatch stopwatch = SimonManager.getStopwatch((String)NAME);
        for (int i = 1; i <= this.threads; ++i) {
            new TestThread().start();
            if (i % 500 != 0) continue;
            System.out.println("Created thread: " + i + " (already executed loops " + stopwatch.getCounter() + ", currently active " + stopwatch.getActive() + ")");
        }
        System.out.println("All threads created (already executed loops " + stopwatch.getCounter() + ", currently active " + stopwatch.getActive() + ")");
        this.latch.await();
        System.out.println("All threads finished: " + stopwatch.sample());
    }

    class TestThread
    extends Thread {
        TestThread() {
        }

        public void run() {
            for (int i = 0; i < MultithreadedTester.this.loop; ++i) {
                SimonManager.getStopwatch((String)NAME).start().stop();
            }
            MultithreadedTester.this.latch.countDown();
        }
    }
}

