/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.examples.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Random;
import org.javasimon.Counter;
import org.javasimon.Simon;
import org.javasimon.SimonManager;
import org.javasimon.SimonPattern;
import org.javasimon.StopwatchSample;
import org.javasimon.examples.jdbc.Simple;
import org.javasimon.utils.SimonUtils;

public final class Complex
extends Simple {
    private Random rand = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setUp() throws SQLException {
        Connection c = null;
        try {
            c = DriverManager.getConnection("jdbc:h2:mem:db1;DB_CLOSE_DELAY=-1");
            Statement stmt = c.createStatement();
            stmt.execute("create table foo (id number(6), dsc varchar2(256))");
            stmt.execute("create alias foo_proc for \"org.javasimon.examples.jdbc.h2.StoredProcedures.fooProc\"");
            stmt.close();
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInsertSimple(Connection c) throws SQLException {
        Statement stmt = null;
        try {
            stmt = c.createStatement();
            stmt.executeUpdate(" insert   into foo values (" + this.rand.nextInt(99999) + ", 'This is an another text')  ");
        }
        finally {
            if (stmt != null) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCal1(Connection c) throws SQLException {
        Statement stmt = null;
        try {
            stmt = c.prepareCall("{call foo_proc(" + this.rand.nextInt(99999) + ", 'This text is inserted from stored procedure')}");
            stmt.execute();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private void printMonitoringInfo() {
        System.out.println(SimonUtils.simonTreeString((Simon)SimonManager.getSimon((String)"org.javasimon.jdbc")));
        Collection simons = SimonManager.getSimons((SimonPattern)new SimonPattern("org.javasimon.jdbc.sql.select.*"));
        System.out.println("simons = " + simons);
    }

    private String printJdbcConnectionInfo(Simon jdbcSimon) {
        if (SimonManager.getSimon((String)(jdbcSimon.getName() + ".conn")) != null) {
            StopwatchSample sws = SimonManager.getStopwatch((String)(jdbcSimon.getName() + ".conn")).sample();
            Counter cc = SimonManager.getCounter((String)(jdbcSimon.getName() + ".conn.commits"));
            Counter cr = SimonManager.getCounter((String)(jdbcSimon.getName() + ".conn.rollbacks"));
            return "Connection info:\n  act: " + sws.getActive() + "\n  max act: " + sws.getMaxActive() + '\n' + "  max act ts: " + SimonUtils.presentTimestamp((long)sws.getMaxActiveTimestamp()) + "\n  opn: " + sws.getCounter() + '\n' + "  cls: " + (sws.getCounter() - sws.getActive()) + '\n' + "  min: " + SimonUtils.presentNanoTime((long)sws.getMin()) + ", avg: " + SimonUtils.presentNanoTime((long)((long)sws.getMean())) + ", max: " + SimonUtils.presentNanoTime((long)sws.getMax()) + '\n' + "  max ts: " + SimonUtils.presentTimestamp((long)sws.getMaxTimestamp()) + '\n' + "  comm: " + (cc != null ? cc.sample().getCounter() : 0L) + '\n' + "  roll: " + (cr != null ? cr.sample().getCounter() : 0L) + '\n';
        }
        return null;
    }

    private String printJdbcStatementInfo(Simon jdbcSimon) {
        if (SimonManager.getSimon((String)(jdbcSimon.getName() + ".stmt")) != null) {
            StopwatchSample sws = SimonManager.getStopwatch((String)(jdbcSimon.getName() + ".stmt")).sample();
            return "Statement info:\n  act: " + sws.getActive() + "\n  max act: " + sws.getMaxActive() + "\n  max act ts: " + SimonUtils.presentTimestamp((long)sws.getMaxActiveTimestamp()) + "\n  opn: " + sws.getCounter() + "\n  cls: " + (sws.getCounter() - sws.getActive()) + "\n  min: " + SimonUtils.presentNanoTime((long)sws.getMin()) + ", avg: " + SimonUtils.presentNanoTime((long)((long)sws.getMean())) + ", max: " + SimonUtils.presentNanoTime((long)sws.getMax()) + "\n  max ts: " + SimonUtils.presentTimestamp((long)sws.getMaxTimestamp()) + '\n';
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Class.forName("org.h2.Driver");
        Class.forName("org.javasimon.jdbc4.Driver");
        Complex complex = new Complex();
        complex.setUp();
        Connection conn = null;
        try {
            conn = DriverManager.getConnection("jdbc:simon:h2:mem:db1");
            conn.setAutoCommit(false);
            complex.doInsert(conn);
            complex.doInsertSimple(conn);
            conn.commit();
            complex.doCal1(conn);
            conn.commit();
            complex.doSelect(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        complex.printMonitoringInfo();
    }
}

