/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.examples.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import org.javasimon.Simon;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.javasimon.utils.SimonUtils;

public class Simple {
    private final Random rand = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws SQLException {
        Connection c = null;
        try {
            c = DriverManager.getConnection("jdbc:h2:mem:db1;DB_CLOSE_DELAY=-1");
            Statement stmt = c.createStatement();
            stmt.execute("create table foo (id number(6), dsc varchar2(256))");
            stmt.close();
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doInsert(Connection c) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = c.prepareStatement("insert into foo values (?, ?)  ");
            stmt.setInt(1, this.rand.nextInt(99999));
            stmt.setString(2, "This is a text");
            stmt.executeUpdate();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int doSelect(Connection c) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = c.createStatement();
            rs = stmt.executeQuery("select * from foo");
            int count = 0;
            while (rs.next()) {
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Split main = SimonManager.getStopwatch((String)"org.javasimon.examples.jdbc.main").start();
        Class.forName("org.h2.Driver");
        Class.forName("org.javasimon.jdbc4.Driver");
        Simple s = new Simple();
        s.setUp();
        Connection conn = null;
        try {
            conn = DriverManager.getConnection("jdbc:simon:h2:mem:db1");
            Split ops = SimonManager.getStopwatch((String)"org.javasimon.examples.jdbc.sql").start();
            s.doInsert(conn);
            s.doSelect(conn);
            ops.stop();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        main.stop();
        System.out.println("Simon monitor hierarchy:\n" + SimonUtils.simonTreeString((Simon)SimonManager.getRootSimon()));
    }
}

