/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.examples.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.javasimon.Simon;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.javasimon.jmx.SimonMXBeanImpl;
import org.javasimon.utils.SimonUtils;

public class MonitoredApplication {
    private final Random rand = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws SQLException {
        Connection c = null;
        try {
            c = DriverManager.getConnection("jdbc:h2:mem:db1;DB_CLOSE_DELAY=-1");
            Statement stmt = c.createStatement();
            stmt.execute("create table foo (id number(6), dsc varchar2(256))");
            stmt.close();
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doInsert(Connection c) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = c.prepareStatement("insert into foo values (?, ?)  ");
            stmt.setInt(1, this.rand.nextInt(99999));
            stmt.setString(2, "This is a text");
            stmt.executeUpdate();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int doSelect(Connection c) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = c.createStatement();
            rs = stmt.executeQuery("select * from foo");
            int count = 0;
            while (rs.next()) {
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private static SimonMXBeanImpl register() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName name = new ObjectName("org.javasimon.jmx.example:type=Simon");
            if (mbs.isRegistered(name)) {
                mbs.unregisterMBean(name);
            }
            SimonMXBeanImpl simon = new SimonMXBeanImpl(SimonManager.manager());
            mbs.registerMBean(simon, name);
            System.out.println("SimonMXBean registerd under name: " + name);
            return simon;
        }
        catch (JMException e) {
            System.out.println("SimonMXBean registration failed!\n" + e);
            return null;
        }
    }

    private static void unregister() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName name = new ObjectName("org.javasimon.jmx.example:type=Simon");
            if (mbs.isRegistered(name)) {
                mbs.unregisterMBean(name);
            }
            System.out.println("SimonMXBean was unregisterd");
        }
        catch (JMException e) {
            System.out.println("SimonMXBean unregistration failed!\n" + e);
        }
    }

    private static void waitForEnterPressed() {
        try {
            System.out.println("\nPress <Enter> to continue...");
            System.in.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Split main = SimonManager.getStopwatch((String)"org.javasimon.examples.jmx.main").start();
        Class.forName("org.h2.Driver");
        Class.forName("org.javasimon.jdbc4.Driver");
        MonitoredApplication s = new MonitoredApplication();
        s.setUp();
        Connection conn = null;
        try {
            conn = DriverManager.getConnection("jdbc:simon:h2:mem:db1");
            Split ops = SimonManager.getStopwatch((String)"org.javasimon.examples.jmx.sql").start();
            s.doInsert(conn);
            s.doSelect(conn);
            ops.stop();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        main.stop();
        System.out.println("Simon monitor hierarchy:\n" + SimonUtils.simonTreeString((Simon)SimonManager.getRootSimon()));
        MonitoredApplication.register();
        MonitoredApplication.waitForEnterPressed();
        MonitoredApplication.unregister();
    }
}

