/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.examples.jmx;

import java.lang.management.ManagementFactory;
import javax.management.JMException;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.javasimon.Counter;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.javasimon.Stopwatch;
import org.javasimon.jmx.SimonMXBean;
import org.javasimon.jmx.SimonMXBeanImpl;

public class StandaloneExample {
    private static SimonMXBean register() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName name = new ObjectName("org.javasimon.jmx.example:type=Simon");
            if (mbs.isRegistered(name)) {
                mbs.unregisterMBean(name);
            }
            SimonMXBeanImpl simon = new SimonMXBeanImpl(SimonManager.manager());
            mbs.registerMBean(simon, name);
            System.out.println("SimonMXBean registerd under name: " + name);
            return simon;
        }
        catch (JMException e) {
            System.out.println("SimonMXBean registration failed!\n" + e);
            return null;
        }
    }

    private static void unregister() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName name = new ObjectName("org.javasimon.jmx.example:type=Simon");
            if (mbs.isRegistered(name)) {
                mbs.unregisterMBean(name);
            }
            System.out.println("SimonMXBean was unregisterd");
        }
        catch (JMException e) {
            System.out.println("SimonMXBean unregistration failed!\n" + e);
        }
    }

    public static void main(String[] args) throws MalformedObjectNameException {
        Stopwatch stopwatch = SimonManager.getStopwatch((String)"org.javasimon.jmx.example1");
        Counter counter = SimonManager.getCounter((String)"org.javasimon.jmx.example2");
        Split s = stopwatch.start();
        try {
            Thread.sleep(632L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        s.stop();
        counter.increase(52L);
        counter.decrease(12L);
        counter.increase(18L);
        StandaloneExample.register();
        SimonMXBean simon = JMX.newMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), new ObjectName("org.javasimon.jmx.example:type=Simon"), SimonMXBean.class);
        System.out.println("counter = " + simon.getCounterSample("org.javasimon.jmx.example2"));
        System.out.println("stopwatch = " + simon.getStopwatchSample("org.javasimon.jmx.example1"));
        StandaloneExample.unregister();
    }
}

