/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.configuration.needle;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jbehave.core.annotations.UsingSteps;
import org.jbehave.core.annotations.needle.UsingNeedle;
import org.jbehave.core.configuration.AnnotationBuilder;
import org.jbehave.core.configuration.AnnotationFinder;
import org.jbehave.core.configuration.AnnotationMonitor;
import org.jbehave.core.configuration.AnnotationRequired;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.PrintStreamAnnotationMonitor;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.needle.NeedleStepsFactory;
import org.jbehave.core.steps.needle.configuration.CreateInstanceByDefaultConstructor;
import org.needle4j.injection.InjectionProvider;
import org.needle4j.injection.InjectionProviderInstancesSupplier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeedleAnnotationBuilder
extends AnnotationBuilder {
    private final Set<InjectionProvider<?>> provider = new HashSet();
    private final Set<Class<?>> stepsClasses = new HashSet();
    private NeedleStepsFactory factory;

    public NeedleAnnotationBuilder(Class<?> annotatedClass, AnnotationMonitor annotationMonitor) {
        super(annotatedClass, annotationMonitor);
    }

    public NeedleAnnotationBuilder(Class<?> annotatedClass) {
        this(annotatedClass, (AnnotationMonitor)new PrintStreamAnnotationMonitor());
    }

    public Configuration buildConfiguration() throws AnnotationRequired {
        AnnotationFinder finder = this.annotationFinder();
        if (finder.isAnnotationPresent(UsingSteps.class)) {
            this.stepsClasses.addAll(finder.getAnnotatedClasses(UsingSteps.class, Object.class, "instances"));
        }
        if (finder.isAnnotationPresent(UsingNeedle.class)) {
            List supplierClasses = finder.getAnnotatedValues(UsingNeedle.class, Class.class, "supplier");
            for (Class supplierClass : supplierClasses) {
                this.provider.addAll(((InjectionProviderInstancesSupplier)CreateInstanceByDefaultConstructor.INSTANCE.apply(supplierClass)).get());
            }
            List providerClasses = finder.getAnnotatedValues(UsingNeedle.class, Class.class, "provider");
            for (Class providerClass : providerClasses) {
                this.provider.add((InjectionProvider<?>)CreateInstanceByDefaultConstructor.INSTANCE.apply(providerClass));
            }
        } else {
            this.annotationMonitor().annotationNotFound(UsingNeedle.class, (Object)this.annotatedClass());
        }
        return super.buildConfiguration();
    }

    public InjectableStepsFactory buildStepsFactory(Configuration configuration) {
        this.factory = new NeedleStepsFactory(configuration, this.provider, this.stepsClasses.toArray(new Class[this.stepsClasses.size()]));
        return this.factory;
    }

    protected <T, V extends T> T instanceOf(Class<T> type, Class<V> ofClass) {
        if (this.factory != null) {
            return (T)this.factory.createInstanceOfType(ofClass);
        }
        return (T)super.instanceOf(type, ofClass);
    }

    public Set<InjectionProvider<?>> getProvider() {
        return this.provider;
    }

    public Set<Class<?>> getStepsClasses() {
        return this.stepsClasses;
    }
}

