/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps.needle;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbehave.core.annotations.AsParameterConverter;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.MostUsefulConfiguration;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.Steps;
import org.jbehave.core.steps.needle.configuration.CollectInjectionProvidersFromStepsInstance;
import org.jbehave.core.steps.needle.configuration.CreateInstanceByDefaultConstructor;
import org.jbehave.core.steps.needle.configuration.JBehaveNeedleConfiguration;
import org.needle4j.NeedleTestcase;
import org.needle4j.injection.InjectionProvider;
import org.needle4j.reflection.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeedleStepsFactory
extends NeedleTestcase
implements InjectableStepsFactory {
    private final Map<Class<?>, Object> cachedTypeInstances = new LinkedHashMap();
    private final Configuration configuration;
    private Class<?>[] steps;

    public NeedleStepsFactory(Configuration configuration, Class<?> ... steps) {
        this(configuration, (Set<InjectionProvider<?>>)null, steps);
    }

    public NeedleStepsFactory(Configuration configuration, Set<InjectionProvider<?>> injectionProviders, Class<?> ... steps) {
        super(NeedleStepsFactory.setUpInjectionProviders("jbehave-needle"));
        if (injectionProviders != null) {
            this.addInjectionProvider(NeedleStepsFactory.toArray(injectionProviders));
        }
        this.configuration = this.configuration == null ? new MostUsefulConfiguration() : configuration;
        this.steps = steps;
    }

    public List<CandidateSteps> createCandidateSteps() {
        ArrayList<CandidateSteps> result = new ArrayList<CandidateSteps>();
        for (Class<?> type : this.steps) {
            if (!NeedleStepsFactory.hasAnnotatedMethods(type)) continue;
            this.configuration.parameterConverters().addConverters(this.methodReturningConverters(type));
            result.add((CandidateSteps)new Steps(this.configuration, type, (InjectableStepsFactory)this));
        }
        return result;
    }

    public Object createInstanceOfType(Class<?> type) {
        Object instance = this.cachedTypeInstances.get(type);
        if (instance == null) {
            try {
                Object stepsInstance = this.createInstanceUsingNeedleTestCase(type);
                InjectionProvider<?>[] foundProviders = CollectInjectionProvidersFromStepsInstance.INSTANCE.apply(stepsInstance);
                this.addInjectionProvider(foundProviders);
                this.initTestcase(stepsInstance);
                this.cachedTypeInstances.put(type, stepsInstance);
                return stepsInstance;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return instance;
    }

    private Object createInstanceUsingNeedleTestCase(Class<?> type) throws IllegalStateException {
        try {
            Object instance = ReflectionUtil.invokeMethod((Object)((Object)this), (String)"getInstanceByConstructorInjection", (Object[])new Object[]{type});
            if (instance == null) {
                instance = CreateInstanceByDefaultConstructor.INSTANCE.apply(type);
            }
            if (instance == null) {
                throw new IllegalStateException("failed to create instance of type " + type.getCanonicalName());
            }
            return instance;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private List<ParameterConverters.ParameterConverter> methodReturningConverters(Class<?> type) {
        ArrayList<ParameterConverters.ParameterConverter> converters = new ArrayList<ParameterConverters.ParameterConverter>();
        for (Method method : type.getMethods()) {
            if (!method.isAnnotationPresent(AsParameterConverter.class)) continue;
            converters.add((ParameterConverters.ParameterConverter)new ParameterConverters.MethodReturningConverter(method, type, (InjectableStepsFactory)this));
        }
        return converters;
    }

    public void addInjectionProviders(Set<InjectionProvider<?>> providers) {
        if (providers != null) {
            this.addInjectionProvider(NeedleStepsFactory.toArray(providers));
        }
    }

    static boolean hasAnnotatedMethods(Type type) {
        if (type instanceof Class) {
            for (Method method : ((Class)type).getMethods()) {
                for (Annotation annotation : method.getAnnotations()) {
                    if (!annotation.annotationType().getName().startsWith("org.jbehave.core.annotations")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static InjectionProvider<?>[] setUpInjectionProviders(String resourceName) {
        return new JBehaveNeedleConfiguration(resourceName).getInjectionProviders();
    }

    static InjectionProvider<?>[] toArray(Set<InjectionProvider<?>> injectionProviders) {
        return injectionProviders.toArray(new InjectionProvider[injectionProviders.size()]);
    }
}

