/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps.needle.configuration;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.jbehave.core.annotations.needle.NeedleInjectionProvider;
import org.needle4j.injection.InjectionProvider;
import org.needle4j.injection.InjectionProviderInstancesSupplier;
import org.needle4j.reflection.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CollectInjectionProvidersFromStepsInstance {
    INSTANCE;


    public final <T> InjectionProvider<?>[] apply(T instance) {
        LinkedHashSet<InjectionProvider> providers = new LinkedHashSet<InjectionProvider>();
        for (Field field : ReflectionUtil.getAllFieldsWithAnnotation(instance, NeedleInjectionProvider.class)) {
            field.setAccessible(true);
            try {
                Object value = field.get(instance);
                if (value instanceof InjectionProvider[]) {
                    providers.addAll(Arrays.asList((InjectionProvider[])value));
                    continue;
                }
                if (value instanceof InjectionProvider) {
                    providers.add((InjectionProvider)value);
                    continue;
                }
                if (value instanceof InjectionProviderInstancesSupplier) {
                    providers.addAll(((InjectionProviderInstancesSupplier)value).get());
                    continue;
                }
                throw new IllegalStateException("Fields annotated with NeedleInjectionProviders must be of type InjectionProviderInstancesSupplier, InjectionProvider or InjectionProvider[]");
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return providers.toArray(new InjectionProvider[providers.size()]);
    }
}

