/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps.needle.configuration;

import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.jbehave.core.steps.needle.configuration.CreateInstanceByDefaultConstructor;
import org.jbehave.core.steps.needle.configuration.LoadResourceBundle;
import org.jbehave.core.steps.needle.configuration.ReadInjectionProviderClassNames;
import org.needle4j.injection.InjectionProvider;
import org.needle4j.injection.InjectionProviderInstancesSupplier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBehaveNeedleConfiguration {
    public static final String RESOURCE_JBEHAVE_NEEDLE = "jbehave-needle";
    private final LoadResourceBundle loadResourceBundle = LoadResourceBundle.INSTANCE;
    private final ReadInjectionProviderClassNames readInjectionProviderClassNames = ReadInjectionProviderClassNames.INSTANCE;
    private final CreateInstanceByDefaultConstructor createInstance = CreateInstanceByDefaultConstructor.INSTANCE;
    private final Set<InjectionProvider<?>> injectionProviders = new HashSet();

    public JBehaveNeedleConfiguration() {
        this(RESOURCE_JBEHAVE_NEEDLE);
    }

    public JBehaveNeedleConfiguration(String resourceName) {
        ResourceBundle resourceBundle = this.loadResourceBundle.apply(resourceName);
        Set<String> classNames = this.readInjectionProviderClassNames.apply(resourceBundle);
        for (String className : classNames) {
            try {
                InjectionProviderInstancesSupplier supplier;
                Set providers;
                Class<?> clazz = Class.forName(className);
                if (JBehaveNeedleConfiguration.isInjectionProvider(clazz)) {
                    this.injectionProviders.add((InjectionProvider)this.createInstance.apply(clazz));
                    continue;
                }
                if (!JBehaveNeedleConfiguration.isInjectionProviderInstanceSupplier(clazz) || (providers = (supplier = (InjectionProviderInstancesSupplier)this.createInstance.apply(clazz)).get()) == null) continue;
                this.injectionProviders.addAll(providers);
            }
            catch (Exception e) {
                throw new IllegalStateException("failed to initialize custom injection providers", e);
            }
        }
    }

    public InjectionProvider<?>[] getInjectionProviders() {
        return this.injectionProviders.toArray(new InjectionProvider[this.injectionProviders.size()]);
    }

    static boolean isInjectionProvider(Class<?> type) {
        return InjectionProvider.class.isAssignableFrom(type);
    }

    static boolean isInjectionProviderInstanceSupplier(Class<?> type) {
        return InjectionProviderInstancesSupplier.class.isAssignableFrom(type);
    }
}

