/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.selenium;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.jbehave.web.selenium.WebDriverProvider;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;

public abstract class DelegatingWebDriverProvider
implements WebDriverProvider {
    protected WebDriver delegate;

    public WebDriver get() {
        return this.delegate;
    }

    public void saveScreenshotTo(String path) {
        WebDriver driver = this.get();
        if (driver instanceof TakesScreenshot) {
            File file = new File(path);
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
                byte[] bytes = (byte[])((TakesScreenshot)driver).getScreenshotAs(OutputType.BYTES);
                IOUtils.write((byte[])bytes, (OutputStream)new FileOutputStream(file));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to save screenshot to " + file, e);
            }
        }
    }
}

