/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.selenium;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;
import org.jbehave.web.selenium.ContextView;

public class LocalFrameContextView
implements ContextView {
    private JFrame frame;
    private JLabel label;
    private int width;
    private int height;
    private int x;
    private int y;

    public LocalFrameContextView() {
        this.sized(380, 85);
        this.located(0, 0);
    }

    public LocalFrameContextView sized(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public LocalFrameContextView located(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public synchronized void show(String message) {
        if (this.frame == null) {
            this.initialize();
        }
        this.label.setText("<html>" + message + "</html>");
    }

    public synchronized void close() {
        if (this.frame != null) {
            this.frame.setVisible(false);
            this.frame.dispose();
            this.frame = null;
            this.label = null;
        }
    }

    private void initialize() {
        this.frame = new JFrame();
        this.label = new JLabel();
        this.frame.setAlwaysOnTop(true);
        this.frame.setSize(this.width, this.height);
        this.frame.setLocation(this.x, this.y);
        this.frame.setUndecorated(true);
        JPanel panel = new JPanel();
        this.frame.setContentPane(panel);
        panel.setLayout(new BorderLayout());
        this.label.setBorder(new EmptyBorder(3, 3, 3, 3));
        panel.add((Component)this.label, "Center");
        MouseInputAdapter mia = new MouseInputAdapter(){
            private Point mousePressedScreenCoords;
            private Point mousePressedCompCoords;

            public void mouseReleased(MouseEvent e) {
                this.mousePressedScreenCoords = null;
                this.mousePressedCompCoords = null;
            }

            public void mousePressed(MouseEvent e) {
                this.mousePressedScreenCoords = e.getLocationOnScreen();
                this.mousePressedCompCoords = e.getPoint();
            }

            public void mouseDragged(MouseEvent e) {
                Point currCoords = e.getLocationOnScreen();
                LocalFrameContextView.this.x = this.mousePressedScreenCoords.x + (currCoords.x - this.mousePressedScreenCoords.x) - this.mousePressedCompCoords.x;
                LocalFrameContextView.this.y = this.mousePressedScreenCoords.y + (currCoords.y - this.mousePressedScreenCoords.y) - this.mousePressedCompCoords.y;
                LocalFrameContextView.this.frame.setLocation(LocalFrameContextView.this.x, LocalFrameContextView.this.y);
            }
        };
        this.frame.addMouseListener(mia);
        this.frame.addMouseMotionListener(mia);
        this.frame.setVisible(true);
    }
}

