/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.selenium;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.condition.ConditionRunner;
import com.thoughtworks.selenium.condition.JUnitConditionRunner;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.web.selenium.SeleniumContext;
import org.jbehave.web.selenium.WebDriverProvider;

public class SeleniumConfiguration
extends Configuration {
    private Selenium selenium = SeleniumConfiguration.defaultSelenium();
    private SeleniumContext seleniumContext = new SeleniumContext();
    private WebDriverProvider driverProvider;

    public Selenium selenium() {
        return this.selenium;
    }

    public SeleniumConfiguration useSelenium(Selenium selenium) {
        this.selenium = selenium;
        return this;
    }

    public SeleniumContext seleniumContext() {
        return this.seleniumContext;
    }

    public SeleniumConfiguration useSeleniumContext(SeleniumContext seleniumContext) {
        this.seleniumContext = seleniumContext;
        return this;
    }

    public WebDriverProvider webDriverProvider() {
        return this.driverProvider;
    }

    public SeleniumConfiguration useWebDriverProvider(WebDriverProvider webDriverProvider) {
        this.driverProvider = webDriverProvider;
        return this;
    }

    public static Selenium defaultSelenium() {
        return new DefaultSelenium("localhost", 4444, "*firefox", "http://localhost:8080");
    }

    public static ConditionRunner defaultConditionRunner(Selenium selenium) {
        return new JUnitConditionRunner(selenium, 10, 100, 1000);
    }
}

