/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.selenium;

import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.condition.Condition;
import com.thoughtworks.selenium.condition.ConditionRunner;
import com.thoughtworks.selenium.condition.Not;
import com.thoughtworks.selenium.condition.Presence;
import com.thoughtworks.selenium.condition.Text;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public abstract class SeleniumPage {
    protected final Selenium selenium;
    protected final ConditionRunner conditionRunner;

    public SeleniumPage(Selenium selenium, ConditionRunner conditionRunner) {
        this.selenium = selenium;
        this.conditionRunner = conditionRunner;
    }

    public void open(String url) {
        this.selenium.open(url);
    }

    public void click(String locator) {
        this.selenium.click(locator);
    }

    public void clickButton(String name) {
        this.click("//input[@value='" + name + "']");
    }

    public void clickLink(String name) {
        this.click("link=" + name + "");
    }

    public void select(String locator, String option) {
        this.selenium.select(locator, option);
    }

    public void selectByLabel(String locator, String label) {
        this.select(locator, "label=" + label);
    }

    public void selectByValue(String locator, String value) {
        this.select(locator, "value=" + value);
    }

    public void type(String locator, String value) {
        this.selenium.type(locator, value);
    }

    public String text(String locator) {
        return this.selenium.getText(locator);
    }

    public String value(String locator) {
        return this.selenium.getValue(locator);
    }

    public void textIsVisible(String text) {
        this.textIsVisible(text, null);
    }

    public void textIsVisible(String text, String locator) {
        this.waitFor((Condition)new Text(text, locator));
    }

    public void textIsNotVisible(String text) {
        this.textIsNotVisible(text, null);
    }

    public void textIsNotVisible(String text, String locator) {
        this.waitFor((Condition)new Not((Condition)new Text(text, locator)));
    }

    public void waitFor(Condition condition) {
        this.conditionRunner.waitFor(condition);
    }

    public void waitForPageToLoad() {
        this.waitForPageToLoad(30);
    }

    public void waitForPageToLoad(int seconds) {
        String timeout = String.valueOf(seconds * 1000);
        this.selenium.waitForPageToLoad(timeout);
    }

    public static void waitFor(int seconds) {
        try {
            TimeUnit.SECONDS.sleep(seconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static class NonBlank
    extends Presence {
        private String locator;

        public NonBlank(String locator) {
            super(locator);
            this.locator = locator;
        }

        public boolean isTrue(ConditionRunner.Context context) {
            String text = null;
            if (super.isTrue(context)) {
                text = context.getSelenium().getText(this.locator);
            }
            return StringUtils.isNotBlank(text);
        }
    }
}

