/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.selenium;

import java.net.MalformedURLException;
import java.net.URL;
import org.jbehave.web.selenium.DelegatingWebDriverProvider;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Platform;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public class RemoteWebDriverProvider
extends DelegatingWebDriverProvider {
    protected DesiredCapabilities desiredCapabilities;
    private boolean verbose = false;

    public RemoteWebDriverProvider() {
        this(RemoteWebDriverProvider.defaultDesiredCapabilities());
    }

    public static DesiredCapabilities defaultDesiredCapabilities() {
        DesiredCapabilities desiredCapabilities = DesiredCapabilities.firefox();
        desiredCapabilities.setVersion("3.6.");
        desiredCapabilities.setPlatform(Platform.WINDOWS);
        desiredCapabilities.setCapability("takesScreenshot", true);
        return desiredCapabilities;
    }

    public RemoteWebDriverProvider(DesiredCapabilities desiredCapabilities) {
        this.desiredCapabilities = desiredCapabilities;
    }

    public void initialize() {
        ScreenshootingRemoteWebDriver remoteWebDriver;
        URL url = null;
        try {
            url = this.createRemoteURL();
            remoteWebDriver = new ScreenshootingRemoteWebDriver(url, this.desiredCapabilities);
        }
        catch (Throwable e) {
            if (this.verbose) {
                System.err.println("*********** Remote WebDriver Initialization Failure ************");
                e.printStackTrace(System.err);
            }
            throw new UnsupportedOperationException("Connecting to remote URL '" + url + "' failed: " + e.getMessage(), e);
        }
        this.delegate.set(remoteWebDriver);
    }

    public URL createRemoteURL() throws MalformedURLException {
        String url = System.getProperty("REMOTE_WEBDRIVER_URL");
        if (url == null) {
            throw new UnsupportedOperationException("REMOTE_WEBDRIVER_URL property not specified");
        }
        return new URL(url);
    }

    public void useVerbosity(boolean verbose) {
        this.verbose = verbose;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ScreenshootingRemoteWebDriver
    extends RemoteWebDriver
    implements TakesScreenshot {
        public ScreenshootingRemoteWebDriver(URL remoteURL, DesiredCapabilities desiredCapabilities) {
            super(remoteURL, (Capabilities)desiredCapabilities);
        }

        public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
            String base64 = this.execute("screenshot").getValue().toString();
            return (X)target.convertFromBase64Png(base64);
        }
    }
}

