/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.selenium;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbehave.core.model.Story;
import org.jbehave.core.reporters.NullStoryReporter;
import org.jbehave.web.selenium.SauceWebDriverProvider;
import org.jbehave.web.selenium.WebDriverProvider;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;

public class SauceContextStoryReporter
extends NullStoryReporter {
    private final WebDriverProvider webDriverProvider;
    private ThreadLocal<String> storyName = new ThreadLocal();
    private ThreadLocal<SessionId> sessionIds = new ThreadLocal();
    private ThreadLocal<Boolean> passed = new ThreadLocal();

    public SauceContextStoryReporter(WebDriverProvider webDriverProvider) {
        this.webDriverProvider = webDriverProvider;
    }

    public void beforeStory(Story story, boolean givenStory) {
        this.storyName.set(story.getName());
        this.passed.set(true);
    }

    public void beforeScenario(String title) {
        this.sessionIds.set(((RemoteWebDriver)this.webDriverProvider.get()).getSessionId());
    }

    public void failed(String step, Throwable cause) {
        this.passed.set(false);
    }

    public void afterStory(boolean givenStory) {
        SessionId sessionId = this.sessionIds.get();
        if (sessionId == null) {
            return;
        }
        try {
            String payload = "{\"tags\":[" + this.getJobTags() + "], \"passed\":\"" + this.passed.get() + "\",\"name\":\" " + this.getJobName() + "\"}";
            URL url = new URL("http://saucelabs.com/rest/v1/" + SauceWebDriverProvider.getSauceUser() + "/jobs/" + sessionId.toString());
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(SauceWebDriverProvider.getSauceUser(), SauceWebDriverProvider.getSauceAccessKey().toCharArray());
                }
            });
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("PUT");
            OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
            writer.write(payload);
            writer.close();
            int rc = connection.getResponseCode();
            if (rc == 200) {
                String s;
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                Pattern p = Pattern.compile("http.*\\.flv");
                while ((s = reader.readLine()) != null) {
                    Matcher matcher = p.matcher(s);
                    if (!matcher.find()) continue;
                    System.out.println("Saucelabs Video: " + matcher.group());
                }
            }
        }
        catch (IOException e) {
            System.err.println("Error updating Saucelabs job info: " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected String getJobName() {
        return this.storyName.get();
    }

    protected String getJobTags() {
        return "";
    }
}

