/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.selenium;

import java.util.List;
import java.util.Set;
import org.jbehave.web.selenium.LazyWebDriver;
import org.jbehave.web.selenium.WebDriverProvider;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebDriverPage
implements WebDriver {
    private WebDriver webDriver;
    private final WebDriverProvider driverProvider;

    public WebDriverPage(WebDriverProvider driverProvider) {
        this.driverProvider = driverProvider;
        this.webDriver = new LazyWebDriver(driverProvider);
    }

    public void get(String url) {
        this.makeNonLazy();
        this.webDriver().get(url);
    }

    public String getCurrentUrl() {
        this.makeNonLazy();
        return this.webDriver().getCurrentUrl();
    }

    public String getTitle() {
        this.makeNonLazy();
        return this.webDriver().getTitle();
    }

    public List<WebElement> findElements(By by) {
        this.makeNonLazy();
        return this.webDriver().findElements(by);
    }

    public WebElement findElement(By by) {
        this.makeNonLazy();
        return this.webDriver().findElement(by);
    }

    public String getPageSource() {
        this.makeNonLazy();
        return this.webDriver().getPageSource();
    }

    public void close() {
        this.makeNonLazy();
        this.webDriver().close();
    }

    public void quit() {
        this.makeNonLazy();
        this.webDriver().quit();
    }

    public Set<String> getWindowHandles() {
        this.makeNonLazy();
        return this.webDriver().getWindowHandles();
    }

    public String getWindowHandle() {
        this.makeNonLazy();
        return this.webDriver().getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo() {
        this.makeNonLazy();
        return this.webDriver().switchTo();
    }

    public WebDriver.Navigation navigate() {
        this.makeNonLazy();
        return this.webDriver().navigate();
    }

    public WebDriver.Options manage() {
        this.makeNonLazy();
        return this.webDriver().manage();
    }

    private synchronized void makeNonLazy() {
        this.webDriver = this.driverProvider.get();
    }

    protected WebDriver webDriver() {
        return this.webDriver;
    }
}

