/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.selenium;

import java.util.HashMap;
import java.util.Map;
import org.jbehave.web.selenium.DelegatingWebDriverProvider;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.ProfilesIni;

public class FirefoxWebDriverProvider
extends DelegatingWebDriverProvider {
    public static final String FIREFOX_PROFILE = "JBEHAVE_WEBDRIVER_FIREFOX_PROFILE";
    public static final Map<Integer, Long> driverToThreadMap = new HashMap<Integer, Long>(11);

    public void initialize() {
        String profileName = System.getProperty(FIREFOX_PROFILE);
        FirefoxBinary binary = new FirefoxBinary();
        this.decorateFirefoxBinary(binary);
        if (profileName != null) {
            ProfilesIni allProfilesIni = new ProfilesIni();
            FirefoxProfile profile = allProfilesIni.getProfile(profileName);
            profile.setAcceptUntrustedCertificates(false);
            FirefoxDriver firefoxDriver = new FirefoxDriver(binary, profile);
            this.delegate.set(firefoxDriver);
        } else {
            FirefoxDriver fireFoxDriver = null;
            final WebDriver[] fireFoxDriverz = new WebDriver[1];
            fireFoxDriver = new FirefoxDriver(binary, null){

                protected void stopClient() {
                    super.stopClient();
                    driverToThreadMap.remove(System.identityHashCode(fireFoxDriverz[0]));
                    FirefoxWebDriverProvider.this.ending();
                }

                public void close() {
                    super.close();
                }
            };
            fireFoxDriverz[0] = fireFoxDriver;
            this.delegate.set(fireFoxDriver);
            if (!driverToThreadMap.containsKey(System.identityHashCode(fireFoxDriver))) {
                driverToThreadMap.put(System.identityHashCode(fireFoxDriver), Thread.currentThread().getId());
            }
        }
    }

    protected void ending() {
    }

    protected void decorateFirefoxBinary(FirefoxBinary binary) {
    }
}

