/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.selenium;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jbehave.core.model.Story;
import org.jbehave.web.selenium.SauceWebDriverProvider;
import org.jbehave.web.selenium.SeleniumContext;
import org.jbehave.web.selenium.SeleniumContextStoryReporter;
import org.jbehave.web.selenium.WebDriverProvider;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SauceContextStoryReporter
extends SeleniumContextStoryReporter {
    private final WebDriverProvider webDriverProvider;
    private ThreadLocal<String> storyName = new ThreadLocal();
    private ThreadLocal<SessionId> sessionIds = new ThreadLocal();
    private ThreadLocal<Boolean> passed = new ThreadLocal();
    private Map<String, String> storyToJobIds = new HashMap<String, String>();
    private static final Pattern SAUCE_LABS_VIDEO_URL_PATTERN = Pattern.compile("http.*\\.flv");

    public SauceContextStoryReporter(WebDriverProvider webDriverProvider, SeleniumContext seleniumContext, Map<String, String> storyToSauceUrlMap) {
        super(seleniumContext);
        this.webDriverProvider = webDriverProvider;
        this.storyToJobIds = storyToSauceUrlMap;
    }

    public void beforeStory(Story story, boolean givenStory) {
        this.storyName.set(story.getName());
        this.passed.set(true);
    }

    @Override
    public void beforeScenario(String title) {
        this.sessionIds.set(((RemoteWebDriver)this.webDriverProvider.get()).getSessionId());
        super.beforeScenario(title);
    }

    public void failed(String step, Throwable cause) {
        this.passed.set(false);
    }

    public void afterStory(boolean givenStory) {
        String storyName = this.storyName.get();
        if (storyName.equals("BeforeStories") || storyName.equals("AfterStories") || storyName.equals("BeforeStory") || storyName.equals("AfterStory") || storyName.equals("BeforeScenario") || storyName.equals("AfterScenario")) {
            return;
        }
        SessionId sessionId = this.sessionIds.get();
        if (sessionId == null) {
            return;
        }
        try {
            String payload = "{\"tags\":[" + this.getJobTags() + "], " + this.getBuildId() + " \"passed\":\"" + this.passed.get() + "\",\"name\":\" " + this.getJobName() + "\"}";
            URL url = new URL("http://saucelabs.com/rest/v1/" + SauceWebDriverProvider.getSauceUser() + "/jobs/" + sessionId.toString());
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(SauceWebDriverProvider.getSauceUser(), SauceWebDriverProvider.getSauceAccessKey().toCharArray());
                }
            });
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("PUT");
            OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
            writer.write(payload);
            writer.close();
            int rc = connection.getResponseCode();
            String jobUrl = null;
            if (rc == 200) {
                jobUrl = this.readResponseLinesFromSauceLabToGetJobUrl(new BufferedReader(new InputStreamReader(connection.getInputStream())));
                System.out.println("Saucelabs Job URL for " + (this.passed.get() != false ? "passing" : "failing") + " '" + storyName + "' : " + jobUrl);
                this.storyToJobIds.put(storyName, jobUrl);
            }
        }
        catch (IOException e) {
            System.err.println("Error updating Saucelabs job info: " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected String readResponseLinesFromSauceLabToGetJobUrl(BufferedReader reader) throws IOException {
        String responseLineFromSauceLabs;
        String jobUrl = "";
        while ((responseLineFromSauceLabs = reader.readLine()) != null) {
            jobUrl = jobUrl + this.processSauceLabsResponseLine(responseLineFromSauceLabs);
        }
        return jobUrl;
    }

    protected String processSauceLabsResponseLine(String responseLineFromSauceLabs) {
        String jobUrl = "";
        Matcher matcher = SAUCE_LABS_VIDEO_URL_PATTERN.matcher(responseLineFromSauceLabs);
        while (matcher.find()) {
            jobUrl = matcher.group().replace("/video.flv", "");
        }
        return jobUrl;
    }

    private String getBuildId() {
        String buildId = System.getProperty("BUILD-ID");
        if (buildId != null) {
            return " \"build\":\"" + buildId + "\",";
        }
        return "";
    }

    protected String getJobName() {
        return this.storyName.get();
    }

    protected String getJobTags() {
        return "";
    }
}

