/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.selenium;

import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.condition.Condition;
import com.thoughtworks.selenium.condition.ConditionRunner;
import com.thoughtworks.selenium.condition.Not;
import com.thoughtworks.selenium.condition.Presence;
import com.thoughtworks.selenium.condition.Text;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class SeleniumPage
implements Selenium {
    protected final Selenium selenium;
    protected final ConditionRunner conditionRunner;

    public SeleniumPage(Selenium selenium, ConditionRunner conditionRunner) {
        this.selenium = selenium;
        this.conditionRunner = conditionRunner;
    }

    public void open(String url) {
        this.selenium.open(url);
    }

    public void openWindow(String url, String windowID) {
        this.selenium.openWindow(url, windowID);
    }

    public void selectWindow(String windowID) {
        this.selenium.selectWindow(windowID);
    }

    public void selectPopUp(String windowID) {
        this.selenium.selectPopUp(windowID);
    }

    public void deselectPopUp() {
        this.selenium.deselectPopUp();
    }

    public void selectFrame(String locator) {
        this.selenium.selectFrame(locator);
    }

    public boolean getWhetherThisFrameMatchFrameExpression(String currentFrameString, String target) {
        return this.selenium.getWhetherThisFrameMatchFrameExpression(currentFrameString, target);
    }

    public boolean getWhetherThisWindowMatchWindowExpression(String currentWindowString, String target) {
        return this.selenium.getWhetherThisWindowMatchWindowExpression(currentWindowString, target);
    }

    public void waitForPopUp(String windowID, String timeout) {
        this.selenium.waitForPopUp(windowID, timeout);
    }

    public void chooseCancelOnNextConfirmation() {
        this.selenium.chooseCancelOnNextConfirmation();
    }

    public void chooseOkOnNextConfirmation() {
        this.selenium.chooseOkOnNextConfirmation();
    }

    public void answerOnNextPrompt(String answer) {
        this.selenium.answerOnNextPrompt(answer);
    }

    public void goBack() {
        this.selenium.goBack();
    }

    public void refresh() {
        this.selenium.refresh();
    }

    public void close() {
        this.selenium.close();
    }

    public boolean isAlertPresent() {
        return this.selenium.isAlertPresent();
    }

    public boolean isPromptPresent() {
        return this.selenium.isPromptPresent();
    }

    public boolean isConfirmationPresent() {
        return this.selenium.isConfirmationPresent();
    }

    public String getAlert() {
        return this.selenium.getAlert();
    }

    public String getConfirmation() {
        return this.selenium.getConfirmation();
    }

    public String getPrompt() {
        return this.selenium.getPrompt();
    }

    public String getLocation() {
        return this.selenium.getLocation();
    }

    public String getTitle() {
        return this.selenium.getTitle();
    }

    public String getBodyText() {
        return this.selenium.getBodyText();
    }

    public String getValue(String locator) {
        return this.selenium.getValue(locator);
    }

    public String getText(String locator) {
        return this.selenium.getText(locator);
    }

    public void highlight(String locator) {
        this.selenium.highlight(locator);
    }

    public String getEval(String script) {
        return this.selenium.getEval(script);
    }

    public boolean isChecked(String locator) {
        return this.selenium.isChecked(locator);
    }

    public String getTable(String tableCellAddress) {
        return this.selenium.getTable(tableCellAddress);
    }

    public String[] getSelectedLabels(String selectLocator) {
        return this.selenium.getSelectedLabels(selectLocator);
    }

    public String getSelectedLabel(String selectLocator) {
        return this.selenium.getSelectedLabel(selectLocator);
    }

    public String[] getSelectedValues(String selectLocator) {
        return this.selenium.getSelectedValues(selectLocator);
    }

    public String getSelectedValue(String selectLocator) {
        return this.selenium.getSelectedValue(selectLocator);
    }

    public String[] getSelectedIndexes(String selectLocator) {
        return this.selenium.getSelectedIndexes(selectLocator);
    }

    public String getSelectedIndex(String selectLocator) {
        return this.selenium.getSelectedIndex(selectLocator);
    }

    public String[] getSelectedIds(String selectLocator) {
        return this.selenium.getSelectedIds(selectLocator);
    }

    public String getSelectedId(String selectLocator) {
        return this.selenium.getSelectedId(selectLocator);
    }

    public boolean isSomethingSelected(String selectLocator) {
        return this.selenium.isSomethingSelected(selectLocator);
    }

    public String[] getSelectOptions(String selectLocator) {
        return this.selenium.getSelectOptions(selectLocator);
    }

    public String getAttribute(String attributeLocator) {
        return this.selenium.getAttribute(attributeLocator);
    }

    public boolean isTextPresent(String pattern) {
        return this.selenium.isTextPresent(pattern);
    }

    public boolean isElementPresent(String locator) {
        return this.selenium.isElementPresent(locator);
    }

    public boolean isVisible(String locator) {
        return this.selenium.isVisible(locator);
    }

    public boolean isEditable(String locator) {
        return this.selenium.isEditable(locator);
    }

    public String[] getAllButtons() {
        return this.selenium.getAllButtons();
    }

    public String[] getAllLinks() {
        return this.selenium.getAllLinks();
    }

    public String[] getAllFields() {
        return this.selenium.getAllFields();
    }

    public String[] getAttributeFromAllWindows(String attributeName) {
        return this.selenium.getAttributeFromAllWindows(attributeName);
    }

    public void dragdrop(String locator, String movementsString) {
        this.selenium.dragdrop(locator, movementsString);
    }

    public void setMouseSpeed(String pixels) {
        this.selenium.setMouseSpeed(pixels);
    }

    public Number getMouseSpeed() {
        return this.selenium.getMouseSpeed();
    }

    public void dragAndDrop(String locator, String movementsString) {
        this.selenium.dragAndDrop(locator, movementsString);
    }

    public void dragAndDropToObject(String locatorOfObjectToBeDragged, String locatorOfDragDestinationObject) {
        this.selenium.dragAndDropToObject(locatorOfObjectToBeDragged, locatorOfDragDestinationObject);
    }

    public void windowFocus() {
        this.selenium.windowFocus();
    }

    public void windowMaximize() {
        this.selenium.windowMaximize();
    }

    public String[] getAllWindowIds() {
        return this.selenium.getAllWindowIds();
    }

    public String[] getAllWindowNames() {
        return this.selenium.getAllWindowNames();
    }

    public String[] getAllWindowTitles() {
        return this.selenium.getAllWindowTitles();
    }

    public String getHtmlSource() {
        return this.selenium.getHtmlSource();
    }

    public void setCursorPosition(String locator, String position) {
        this.selenium.setCursorPosition(locator, position);
    }

    public Number getElementIndex(String locator) {
        return this.selenium.getElementIndex(locator);
    }

    public boolean isOrdered(String locator1, String locator2) {
        return this.selenium.isOrdered(locator1, locator2);
    }

    public Number getElementPositionLeft(String locator) {
        return this.selenium.getElementPositionLeft(locator);
    }

    public Number getElementPositionTop(String locator) {
        return this.selenium.getElementPositionTop(locator);
    }

    public Number getElementWidth(String locator) {
        return this.selenium.getElementWidth(locator);
    }

    public Number getElementHeight(String locator) {
        return this.selenium.getElementHeight(locator);
    }

    public Number getCursorPosition(String locator) {
        return this.selenium.getCursorPosition(locator);
    }

    public String getExpression(String expression) {
        return this.selenium.getExpression(expression);
    }

    public Number getXpathCount(String xpath) {
        return this.selenium.getXpathCount(xpath);
    }

    public Number getCssCount(String css) {
        return this.selenium.getCssCount(css);
    }

    public void assignId(String locator, String identifier) {
        this.selenium.assignId(locator, identifier);
    }

    public void allowNativeXpath(String allow) {
        this.selenium.allowNativeXpath(allow);
    }

    public void ignoreAttributesWithoutValue(String ignore) {
        this.selenium.ignoreAttributesWithoutValue(ignore);
    }

    public void waitForCondition(String script, String timeout) {
        this.selenium.waitForCondition(script, timeout);
    }

    public void setTimeout(String timeout) {
        this.selenium.setTimeout(timeout);
    }

    public void waitForPageToLoad(String timeout) {
        this.selenium.waitForPageToLoad(timeout);
    }

    public void waitForFrameToLoad(String frameAddress, String timeout) {
        this.selenium.waitForFrameToLoad(frameAddress, timeout);
    }

    public String getCookie() {
        return this.selenium.getCookie();
    }

    public String getCookieByName(String name) {
        return this.selenium.getCookieByName(name);
    }

    public boolean isCookiePresent(String name) {
        return this.selenium.isCookiePresent(name);
    }

    public void createCookie(String nameValuePair, String optionsString) {
        this.selenium.createCookie(nameValuePair, optionsString);
    }

    public void deleteCookie(String name, String optionsString) {
        this.selenium.deleteCookie(name, optionsString);
    }

    public void deleteAllVisibleCookies() {
        this.selenium.deleteAllVisibleCookies();
    }

    public void setBrowserLogLevel(String logLevel) {
        this.selenium.setBrowserLogLevel(logLevel);
    }

    public void runScript(String script) {
        this.selenium.runScript(script);
    }

    public void addLocationStrategy(String strategyName, String functionDefinition) {
        this.selenium.addLocationStrategy(strategyName, functionDefinition);
    }

    public void captureEntirePageScreenshot(String filename, String kwargs) {
        this.selenium.captureEntirePageScreenshot(filename, kwargs);
    }

    public void rollup(String rollupName, String kwargs) {
        this.selenium.rollup(rollupName, kwargs);
    }

    public void addScript(String scriptContent, String scriptTagId) {
        this.selenium.addScript(scriptContent, scriptTagId);
    }

    public void removeScript(String scriptTagId) {
        this.selenium.removeScript(scriptTagId);
    }

    public void useXpathLibrary(String libraryName) {
        this.selenium.useXpathLibrary(libraryName);
    }

    public void setContext(String context) {
        this.selenium.setContext(context);
    }

    public void attachFile(String fieldLocator, String fileLocator) {
        this.selenium.attachFile(fieldLocator, fileLocator);
    }

    public void captureScreenshot(String filename) {
        this.selenium.captureScreenshot(filename);
    }

    public String captureScreenshotToString() {
        return this.selenium.captureScreenshotToString();
    }

    public String captureNetworkTraffic(String type) {
        return this.selenium.captureNetworkTraffic(type);
    }

    public void addCustomRequestHeader(String key, String value) {
        this.selenium.addCustomRequestHeader(key, value);
    }

    public String captureEntirePageScreenshotToString(String kwargs) {
        return this.selenium.captureEntirePageScreenshotToString(kwargs);
    }

    public void shutDownSeleniumServer() {
        this.selenium.shutDownSeleniumServer();
    }

    public String retrieveLastRemoteControlLogs() {
        return this.selenium.retrieveLastRemoteControlLogs();
    }

    public void keyDownNative(String keycode) {
        this.selenium.keyDownNative(keycode);
    }

    public void keyUpNative(String keycode) {
        this.selenium.keyUpNative(keycode);
    }

    public void keyPressNative(String keycode) {
        this.selenium.keyPressNative(keycode);
    }

    public void click(String locator) {
        this.selenium.click(locator);
    }

    public void doubleClick(String locator) {
        this.selenium.doubleClick(locator);
    }

    public void contextMenu(String locator) {
        this.selenium.contextMenu(locator);
    }

    public void clickAt(String locator, String coordString) {
        this.selenium.clickAt(locator, coordString);
    }

    public void doubleClickAt(String locator, String coordString) {
        this.selenium.doubleClickAt(locator, coordString);
    }

    public void contextMenuAt(String locator, String coordString) {
        this.selenium.contextMenuAt(locator, coordString);
    }

    public void fireEvent(String locator, String eventName) {
        this.selenium.fireEvent(locator, eventName);
    }

    public void focus(String locator) {
        this.selenium.focus(locator);
    }

    public void keyPress(String locator, String keySequence) {
        this.selenium.keyPress(locator, keySequence);
    }

    public void shiftKeyDown() {
        this.selenium.shiftKeyDown();
    }

    public void shiftKeyUp() {
        this.selenium.shiftKeyUp();
    }

    public void metaKeyDown() {
        this.selenium.metaKeyDown();
    }

    public void metaKeyUp() {
        this.selenium.metaKeyUp();
    }

    public void altKeyDown() {
        this.selenium.altKeyDown();
    }

    public void altKeyUp() {
        this.selenium.altKeyUp();
    }

    public void controlKeyDown() {
        this.selenium.controlKeyDown();
    }

    public void controlKeyUp() {
        this.selenium.controlKeyUp();
    }

    public void keyDown(String locator, String keySequence) {
        this.selenium.keyDown(locator, keySequence);
    }

    public void keyUp(String locator, String keySequence) {
        this.selenium.keyUp(locator, keySequence);
    }

    public void mouseOver(String locator) {
        this.selenium.mouseOver(locator);
    }

    public void mouseOut(String locator) {
        this.selenium.mouseOut(locator);
    }

    public void mouseDown(String locator) {
        this.selenium.mouseDown(locator);
    }

    public void mouseDownRight(String locator) {
        this.selenium.mouseDownRight(locator);
    }

    public void mouseDownAt(String locator, String coordString) {
        this.selenium.mouseDownAt(locator, coordString);
    }

    public void mouseDownRightAt(String locator, String coordString) {
        this.selenium.mouseDownRightAt(locator, coordString);
    }

    public void mouseUp(String locator) {
        this.selenium.mouseUp(locator);
    }

    public void mouseUpRight(String locator) {
        this.selenium.mouseUpRight(locator);
    }

    public void mouseUpAt(String locator, String coordString) {
        this.selenium.mouseUpAt(locator, coordString);
    }

    public void mouseUpRightAt(String locator, String coordString) {
        this.selenium.mouseUpRightAt(locator, coordString);
    }

    public void mouseMove(String locator) {
        this.selenium.mouseMove(locator);
    }

    public void mouseMoveAt(String locator, String coordString) {
        this.selenium.mouseMoveAt(locator, coordString);
    }

    public void clickButton(String name) {
        this.click("//input[@value='" + name + "']");
    }

    public void clickLink(String name) {
        this.click("link=" + name + "");
    }

    public void select(String locator, String option) {
        this.selenium.select(locator, option);
    }

    public void addSelection(String locator, String optionLocator) {
        this.selenium.addSelection(locator, optionLocator);
    }

    public void removeSelection(String locator, String optionLocator) {
        this.selenium.removeSelection(locator, optionLocator);
    }

    public void removeAllSelections(String locator) {
        this.selenium.removeAllSelections(locator);
    }

    public void submit(String formLocator) {
        this.selenium.submit(formLocator);
    }

    public void open(String url, String ignoreResponseCode) {
        this.selenium.open(url, ignoreResponseCode);
    }

    public void selectByLabel(String locator, String label) {
        this.select(locator, "label=" + label);
    }

    public void selectByValue(String locator, String value) {
        this.select(locator, "value=" + value);
    }

    public void type(String locator, String value) {
        this.selenium.type(locator, value);
    }

    public void typeKeys(String locator, String value) {
        this.selenium.typeKeys(locator, value);
    }

    public void setSpeed(String value) {
        this.selenium.setSpeed(value);
    }

    public String getSpeed() {
        return this.selenium.getSpeed();
    }

    public String getLog() {
        return this.selenium.getLog();
    }

    public void check(String locator) {
        this.selenium.check(locator);
    }

    public void uncheck(String locator) {
        this.selenium.uncheck(locator);
    }

    public String text(String locator) {
        return this.selenium.getText(locator);
    }

    public String value(String locator) {
        return this.selenium.getValue(locator);
    }

    public void textIsVisible(String text) {
        this.textIsVisible(text, null);
    }

    public void textIsVisible(String text, String locator) {
        this.waitFor((Condition)new Text(text, locator));
    }

    public void textIsNotVisible(String text) {
        this.textIsNotVisible(text, null);
    }

    public void textIsNotVisible(String text, String locator) {
        this.waitFor((Condition)new Not((Condition)new Text(text, locator)));
    }

    public void waitFor(Condition condition) {
        this.conditionRunner.waitFor(condition);
    }

    public void waitForPageToLoad() {
        this.waitForPageToLoad(30);
    }

    public void waitForPageToLoad(int seconds) {
        String timeout = String.valueOf(seconds * 1000);
        this.selenium.waitForPageToLoad(timeout);
    }

    public static void waitFor(int seconds) {
        try {
            TimeUnit.SECONDS.sleep(seconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setExtensionJs(String extensionJs) {
        this.selenium.setExtensionJs(extensionJs);
    }

    public void start() {
        throw new UnsupportedOperationException("managed by JBehave");
    }

    public void start(String optionsString) {
        throw new UnsupportedOperationException("managed by JBehave");
    }

    public void start(Object optionsObject) {
        throw new UnsupportedOperationException("managed by JBehave");
    }

    public void stop() {
        throw new UnsupportedOperationException("managed by JBehave");
    }

    public void showContextualBanner() {
        this.selenium.showContextualBanner();
    }

    public void showContextualBanner(String className, String methodName) {
        this.selenium.showContextualBanner(className, methodName);
    }

    public static class NonBlank
    extends Presence {
        private String locator;

        public NonBlank(String locator) {
            super(locator);
            this.locator = locator;
        }

        public boolean isTrue(ConditionRunner.Context context) {
            String text = null;
            if (super.isTrue(context)) {
                text = context.getSelenium().getText(this.locator);
            }
            return StringUtils.isNotBlank(text);
        }
    }
}

