/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.clustering.jgroups.subsystem.Attribute;
import org.jboss.as.clustering.jgroups.subsystem.Element;
import org.jboss.as.clustering.jgroups.subsystem.Namespace;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.jgroups.stack.Protocol;

public class JGroupsSubsystemParser
implements XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", "jgroups");
        address.protect();
        ModelNode subsystem = Util.getEmptyOperation((String)"add", (ModelNode)address);
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DEFAULT_STACK: {
                    subsystem.get("default-stack").set(value);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        operations.add(subsystem);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case JGROUPS_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case STACK: {
                            operations.add(this.parseStack(reader, address));
                            continue block10;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private ModelNode parseStack(XMLExtendedStreamReader reader, ModelNode address) throws XMLStreamException {
        String name = null;
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        ModelNode stack = Util.getEmptyOperation((String)"add", null);
        stack.get("address").set(address).add("stack", name);
        if (!reader.hasNext() || reader.nextTag() == 2 || Element.forName(reader.getLocalName()) != Element.TRANSPORT) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton(Element.TRANSPORT));
        }
        this.parseProtocol(reader, stack.get("transport"));
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROTOCOL: {
                    this.parseProtocol(reader, stack.get("protocol").add());
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return stack;
    }

    private void parseProtocol(XMLExtendedStreamReader reader, ModelNode protocol) throws XMLStreamException {
        block14: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    try {
                        Class.forName("org.jgroups.protocols." + value).asSubclass(Protocol.class).newInstance();
                        protocol.get("type").set(value);
                        continue block14;
                    }
                    catch (Exception e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                case SOCKET_BINDING: {
                    protocol.get("socket-binding").set(value);
                    continue block14;
                }
                case DIAGNOSTICS_SOCKET_BINDING: {
                    protocol.get("diagnostics-socket-binding").set(value);
                    continue block14;
                }
                case THREAD_POOL: {
                    protocol.get("thread-pool").set(value);
                    continue block14;
                }
                case OOB_THREAD_POOL: {
                    protocol.get("oob-thread-pool").set(value);
                    continue block14;
                }
                case TIMER_THREAD_POOL: {
                    protocol.get("timer-thread-pool").set(value);
                    continue block14;
                }
                case THREAD_FACTORY: {
                    protocol.get("thread-factory").set(value);
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!protocol.hasDefined("type")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.TYPE));
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (Element.forName(reader.getLocalName()) != Element.PROPERTY) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            int attributes = reader.getAttributeCount();
            String property = null;
            block16: for (int i = 0; i < attributes; ++i) {
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        property = value;
                        continue block16;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (property == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
            }
            String value = reader.getElementText();
            protocol.get("property").add(property, value);
        }
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUri(), false);
        ModelNode model = context.getModelNode();
        if (model.isDefined()) {
            if (model.hasDefined("default-stack")) {
                writer.writeAttribute(Attribute.DEFAULT_STACK.getLocalName(), model.get("default-stack").asString());
            }
            for (Property property : model.get("stack").asPropertyList()) {
                writer.writeStartElement(Element.STACK.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                ModelNode stack = property.getValue();
                this.writeProtocol(writer, stack.get("transport"), Element.TRANSPORT);
                for (ModelNode protocol : stack.get("protocol").asList()) {
                    this.writeProtocol(writer, protocol, Element.PROTOCOL);
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private void writeProtocol(XMLExtendedStreamWriter writer, ModelNode protocol, Element element) throws XMLStreamException {
        writer.writeStartElement(element.getLocalName());
        writer.writeAttribute(Attribute.TYPE.getLocalName(), protocol.get("type").asString());
        if (protocol.has("socket-binding")) {
            writer.writeAttribute(Attribute.SOCKET_BINDING.getLocalName(), protocol.get("socket-binding").asString());
        }
        if (protocol.has("diagnostics-socket-binding")) {
            writer.writeAttribute(Attribute.DIAGNOSTICS_SOCKET_BINDING.getLocalName(), protocol.get("diagnostics-socket-binding").asString());
        }
        if (protocol.has("thread-pool")) {
            writer.writeAttribute(Attribute.THREAD_POOL.getLocalName(), protocol.get("thread-pool").asString());
        }
        if (protocol.has("oob-thread-pool")) {
            writer.writeAttribute(Attribute.OOB_THREAD_POOL.getLocalName(), protocol.get("oob-thread-pool").asString());
        }
        if (protocol.has("timer-thread-pool")) {
            writer.writeAttribute(Attribute.TIMER_THREAD_POOL.getLocalName(), protocol.get("timer-thread-pool").asString());
        }
        if (protocol.has("thread-factory")) {
            writer.writeAttribute(Attribute.THREAD_FACTORY.getLocalName(), protocol.get("thread-factory").asString());
        }
        if (protocol.has("property")) {
            for (Property property : protocol.get("property").asPropertyList()) {
                writer.writeStartElement(Element.PROPERTY.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                writer.writeCharacters(property.getValue().asString());
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }
}

