/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patch.generator.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.jboss.as.patching.generator.PatchGenerator;

@Mojo(name="generate-patch", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class PatchGenMojo
extends AbstractMojo {
    private static final String LOG_FILE = "patchgen.log";
    @Parameter(property="patchConfig", required=true)
    private File patchConfig;
    @Parameter(property="appliesToDist", required=true)
    private File appliesToDist;
    @Parameter(property="updatedDist", required=true)
    private File updatedDist;
    @Parameter(property="outputFile", required=true)
    private File outputFile;
    @Parameter(property="assemblePatchBundle")
    private Boolean assemblePatchBundle;
    @Parameter(property="createTemplate")
    private Boolean createTemplate;
    @Parameter(property="detailedInspection")
    private Boolean detailedInspection;
    @Parameter(property="includeVersion")
    private Boolean includeVersion;
    @Parameter(property="combineWith")
    private File combineWith;
    @Parameter(property="argLine")
    private String argLine;
    @Parameter(property="project.build.directory")
    private File buildDirectory;
    @Parameter(property="plugin.artifacts")
    protected List<Artifact> pluginArtifacts;

    public void execute() throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("java");
        for (String additionalArg : this.getAdditionalArgs()) {
            args.add(additionalArg);
        }
        args.add("-cp");
        args.add(this.getClasspath());
        args.add(PatchGenerator.class.getName());
        args.add("--applies-to-dist=" + this.appliesToDist.getPath());
        args.add("--output-file=" + this.outputFile.getPath());
        args.add("--patch-config=" + this.patchConfig.getPath());
        args.add("--updated-dist=" + this.updatedDist.getPath());
        if (this.assemblePatchBundle != null) {
            args.add("--assemble-patch-bundle");
        }
        if (this.createTemplate != null) {
            args.add("--create-template");
        }
        if (this.detailedInspection != null) {
            args.add("--detailed-inspection");
        }
        if (this.includeVersion != null) {
            args.add("--include-version");
        }
        if (this.combineWith != null) {
            args.add("--combine-with=" + this.combineWith.getPath());
        }
        try {
            Process p = new ProcessBuilder(args).redirectOutput(new File(this.buildDirectory, LOG_FILE)).redirectError(new File(this.buildDirectory, LOG_FILE)).start();
            p.waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException("Execution of PatchGenerator failed. See patchgen.log for details.", e);
        }
        if (!this.outputFile.exists()) {
            throw new MojoExecutionException("Execution of PatchGenerator failed. See patchgen.log for details.");
        }
    }

    private String getClasspath() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Artifact artifact : this.pluginArtifacts) {
            if (first) {
                first = false;
            } else {
                sb.append(File.pathSeparator);
            }
            sb.append(artifact.getFile().getPath());
        }
        return sb.toString();
    }

    private String[] getAdditionalArgs() throws MojoExecutionException {
        if (this.argLine == null || this.argLine.trim().length() == 0) {
            return new String[0];
        }
        try {
            return CommandLineUtils.translateCommandline((String)this.argLine.replace("\n", " ").replaceAll("\r", " "));
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to parse argLine: " + this.argLine, (Exception)((Object)e));
        }
    }
}

