/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter.annotations;

import java.io.DataOutputStream;
import java.io.IOException;
import org.jboss.classfilewriter.annotations.AnnotationValue;
import org.jboss.classfilewriter.constpool.ConstPool;

public class IntAnnotationValue
extends AnnotationValue {
    private final int valueIndex;
    private final int value;

    public IntAnnotationValue(ConstPool constPool, String name, int value) {
        super(constPool, name);
        this.value = value;
        this.valueIndex = constPool.addIntegerEntry(value);
    }

    @Override
    public char getTag() {
        return 'I';
    }

    @Override
    public void writeData(DataOutputStream stream) throws IOException {
        stream.writeShort(this.valueIndex);
    }

    public int getValue() {
        return this.value;
    }
}

