/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter.attributes;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.classfilewriter.attributes.Attribute;
import org.jboss.classfilewriter.constpool.ConstPool;

public class ExceptionsAttribute
extends Attribute {
    public static final String NAME = "Exceptions";
    private final List<String> exceptionClasses = new ArrayList<String>();
    private final List<Short> exceptionClassIndexes = new ArrayList<Short>();
    private final ConstPool constPool;

    public ExceptionsAttribute(ConstPool constPool) {
        super(NAME, constPool);
        this.constPool = constPool;
    }

    public void addExceptionClass(String exception) {
        this.exceptionClasses.add(exception);
        this.exceptionClassIndexes.add(this.constPool.addClassEntry(exception));
    }

    @Override
    public void writeData(DataOutputStream stream) throws IOException {
        stream.writeInt(2 + this.exceptionClassIndexes.size() * 2);
        stream.writeShort(this.exceptionClassIndexes.size());
        for (short i : this.exceptionClassIndexes) {
            stream.writeShort(i);
        }
    }
}

