/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter.attributes;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.attributes.Attribute;
import org.jboss.classfilewriter.code.CodeAttribute;
import org.jboss.classfilewriter.code.StackEntry;
import org.jboss.classfilewriter.code.StackEntryType;
import org.jboss.classfilewriter.code.StackFrame;
import org.jboss.classfilewriter.code.StackFrameType;
import org.jboss.classfilewriter.constpool.ConstPool;

public class StackMapTableAttribute
extends Attribute {
    private static int FULL_FRAME = 255;
    private static int SAME_FRAME_EXTENDED = 251;
    public static final String NAME = "StackMapTable";
    private final ClassMethod method;

    public StackMapTableAttribute(ClassMethod classMethod, ConstPool constPool) {
        super(NAME, constPool);
        this.method = classMethod;
    }

    @Override
    public void writeData(DataOutputStream stream) throws IOException {
        CodeAttribute ca = this.method.getCodeAttribute();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dstream = new DataOutputStream(bout);
        int lastPos = -1;
        for (Map.Entry<Integer, StackFrame> entry : this.method.getCodeAttribute().getStackFrames().entrySet()) {
            int offset = entry.getKey() - lastPos - 1;
            lastPos = entry.getKey();
            StackFrame frame = entry.getValue();
            if (frame.getType() == StackFrameType.SAME_FRAME || frame.getType() == StackFrameType.SAME_FRAME_EXTENDED) {
                this.writeSameFrame(dstream, offset, lastPos, frame);
                continue;
            }
            if (frame.getType() == StackFrameType.SAME_LOCALS_1_STACK && offset < 63) {
                this.writeSameLocals1Stack(dstream, offset, lastPos, frame);
                continue;
            }
            this.writeFullFrame(dstream, offset, lastPos, entry.getValue());
        }
        stream.writeInt(bout.size() + 2);
        stream.writeShort(ca.getStackFrames().size());
        stream.write(bout.toByteArray());
    }

    private void writeSameLocals1Stack(DataOutputStream dstream, int offset, int lastPos, StackFrame frame) throws IOException {
        dstream.writeByte(offset + 64);
        frame.getStackState().getContents().get(0).write(dstream);
    }

    private void writeSameFrame(DataOutputStream dstream, int offset, int lastPos, StackFrame frame) throws IOException {
        if (offset > 63) {
            dstream.writeByte(SAME_FRAME_EXTENDED);
            dstream.writeShort(offset);
        } else {
            dstream.writeByte(offset);
        }
    }

    private void writeFullFrame(DataOutputStream dstream, int offset, int position, StackFrame value) throws IOException {
        dstream.writeByte(FULL_FRAME);
        dstream.writeShort(offset);
        ArrayList<StackEntry> realLocalVars = new ArrayList<StackEntry>(value.getLocalVariableState().getContents().size());
        for (StackEntry i : value.getLocalVariableState().getContents()) {
            if (i.getType() == StackEntryType.TOP) continue;
            realLocalVars.add(i);
        }
        dstream.writeShort(realLocalVars.size());
        for (StackEntry i : realLocalVars) {
            i.write(dstream);
        }
        ArrayList<StackEntry> realStack = new ArrayList<StackEntry>(value.getStackState().getContents().size());
        for (StackEntry i : value.getStackState().getContents()) {
            if (i.getType() == StackEntryType.TOP) continue;
            realStack.add(i);
        }
        dstream.writeShort(realStack.size());
        for (StackEntry i : realStack) {
            i.write(dstream);
        }
    }
}

